package org.webjinn.cms.actions;
import org.apache.struts.action.*;
import org.webjinn.cms.model.CMSTree;
import org.webjinn.cms.model.Page;

/** Creates a new CMS Page (associates file uri with interface uri) */
public class AssociateAction extends CMSAction {

	public ActionForward execute(ActionMapping mapping,
			ActionForm form,
			javax.servlet.http.HttpServletRequest request,
			javax.servlet.http.HttpServletResponse response)
		throws java.lang.Exception {
		try{
			String pageURI = request.getParameter("pageuri");
			String interfaceURI  = request.getParameter("uri");
			CMSTree tree = getCMSTree();
			Page page = tree.getPage(pageURI);
			if (page!=null) tree.removePage(page);
		  tree.addPage(pageURI,interfaceURI);
			return mapping.findForward("SUCCESS");
		} catch (Exception e) {
			request.setAttribute("exception", e);
			return mapping.findForward("FAIL");
		}
	}

}
