package org.webjinn.cms.actions;
import org.apache.struts.action.*;
import org.webjinn.cms.model.CMSTree;
import org.webjinn.cms.model.Item;
import org.webjinn.cms.model.Menu;

/** Creates a new menu and associates it with an item provided via URI */
public class AddMenuAction extends CMSAction {

	public ActionForward execute(ActionMapping mapping,
			ActionForm form,
			javax.servlet.http.HttpServletRequest request,
			javax.servlet.http.HttpServletResponse response)
		throws java.lang.Exception {
		try{
			String uri = request.getParameter("uri");
			String name = request.getParameter("name");
			CMSTree tree = getCMSTree();
			Item el = (Item)tree.resolveInterfaceURI(uri);
			el.associate(name);
			return mapping.findForward("SUCCESS");
		} catch (Exception e) {
			request.setAttribute("exception", e);
			return mapping.findForward("FAIL");
		}
	}

}
