package org.webjinn.cms.actions;
import org.apache.struts.action.*;
import org.webjinn.cms.model.CMSTree;
import org.webjinn.cms.model.Menu;
import org.webjinn.cms.model.Page;
import org.webjinn.cms.model.CSSFile;
import org.webjinn.cms.model.CSSFilesContainer;

/** Removes CSSFile from a cssfiles container (Page or Menu) */
public class AddCSSFileAction extends CMSAction {

	public ActionForward execute(ActionMapping mapping,
			ActionForm form,
			javax.servlet.http.HttpServletRequest request,
			javax.servlet.http.HttpServletResponse response)
		throws java.lang.Exception {
		try{
			String conttype = request.getParameter("conttype");
			String uri = request.getParameter("uri");
      String url = request.getParameter("url");
			CMSTree tree = getCMSTree();
			CSSFilesContainer cont=null;
			if (conttype.equals("menu"))
				cont = (Menu)tree.resolveInterfaceURI(uri);

			if (conttype.equals("page")) 
				cont = tree.getPage(uri);

      CSSFile cssfile = cont.getCSSFile(url);
			if (cssfile==null) {
				cont.addCSSFile(url);
			}
			return mapping.findForward("SUCCESS");
		} catch (Exception e) {
			request.setAttribute("exception", e);
			return mapping.findForward("FAIL");
		}
	}

}
