package org.webjinn.cms.model;
import java.io.*;
import java.sql.*;
import java.util.*;

public class dirutils {

	public static String getRelativePath(String rootDir,File f) {
		try{
			String path=f.getPath().substring(rootDir.length());
			if (!path.startsWith(File.separator)) path=File.separator+path;
			if (path.endsWith(File.separator)) path=path.substring(0,path.length()-1);
			return path;
		} catch (Exception e) {return null;}
	}

	/*
	public static Vector getContainers(javax.servlet.ServletContext context,String uri) throws SQLException,IOException,NullPointerException {
		String rootDir=context.getRealPath("");
		if (uri==null) uri="";
		Vector result=new Vector();
		File[] containers=new File(rootDir+uri).listFiles(new containerFileFilter());
		if (containers!=null) 
			for (int i=0;i<containers.length;i++) {
				PageContainer pc=new PageContainer(context);
				pc.setContainerFile(containers[i]);
				pc.checkPageProperties();
				result.add(pc);
			}
		return result;
	} */


	public static String getFullPath(String rootDir,String uri) {
		uri=uri.replace('/',File.separatorChar);
		String path=rootDir+File.separator+uri;
		if (path.endsWith(File.separator)) path=path.substring(0,path.length()-1);
		return path;
	}


	public static List getDirectories(String rootDir,String uri) throws IOException {
		Vector records=new Vector();
		Hashtable record=new Hashtable(4);
		record.put("name","ROOT");
		record.put("path","/");
		record.put("isparent","true");
		records.add(record);

		if (uri!=null && uri.length()>1) {
			StringTokenizer parents=new StringTokenizer(uri,File.separator);
			String path="";
			if (parents!=null) 
				while (parents.hasMoreTokens()) {
					String name=parents.nextToken();
					path=path+File.separator+name;
					record=new Hashtable(4);
					record.put("name",name);
					record.put("path",path);
					record.put("isparent","true");
					records.add(record);
				}
		}
		File[] subdirs=getSubDirs(rootDir,uri);
		for (int i=0;i<subdirs.length;i++) {
			record=new Hashtable(4);
			record.put("name",subdirs[i].getName());
			record.put("path",getRelativePath(rootDir,subdirs[i]));
			record.put("isparent","false");
			records.add(record);
		}
		return records;
	}

	public static File[] getSubDirs(String rootDir,String uri) throws IOException {
		Vector result=new Vector();
		if (uri==null) uri="";
		FileFilter filter=new dirFileFilter(rootDir);
		return new File(rootDir+uri).listFiles(filter);
	}



	/** IMPORTANT !!! FIXME */
	public static boolean isContainerPage(File pathname) {
		try{
			if (pathname.exists()) {
				BufferedReader reader=new BufferedReader(new InputStreamReader(new FileInputStream(pathname),"Cp1251"));
				try{
					String line;
					while ((line=reader.readLine())!=null)
						if (line.indexOf("<%-- Container Page --%>")>=0) return true;	    
				} finally {reader.close();}
			}
		} catch (Exception e) {return false;}
		return false;
	}

	public static void getDirContainers(File dir,Vector result) {
		File[] containers = dir.listFiles(new containerFileFilter());
		if (containers!=null)
			for (int i=0;i<containers.length;i++) 
				result.add(containers[i]);

		File[] sub=dir.listFiles();
		if (sub!=null) 
			for (int i=0;i<sub.length;i++) 
				if (sub[i].isDirectory()) getDirContainers(sub[i],result);
	}

	/** FIXME */
	public static void deleteDir(javax.servlet.ServletContext context,String uri) throws IOException {
		String rootDir=context.getRealPath("");
		File dir=new File(rootDir+uri);
		if (!dir.exists() || !dir.isDirectory()) return;
		Vector containers=new Vector();
		getDirContainers(dir,containers);
		for (int i=0;i<containers.size();i++) {
			File cont=(File)containers.get(i);
			PageContainer pc=new PageContainer(context);
			pc.setContainerFile(cont);
			pc.delete();
		}
		deleteDir(dir);
	}

	public static void deleteDir(File dir) {
		try{
			File[] files=dir.listFiles();
			if (files!=null)
				for (int i=0;i<files.length;i++)
					if (files[i].isDirectory()) deleteDir(files[i]); else files[i].delete();
			dir.delete();
		} catch (Exception e) {}
	}


	public static File[] getCSSFiles(javax.servlet.ServletContext context) throws IOException {
		String rootDir=context.getRealPath("/shared/css");
		File dir=new File(rootDir);
		if (!dir.exists() || !dir.isDirectory()) return null; 
		return dir.listFiles(new cssFileFilter());
	}

	public static void delCSSFile(javax.servlet.ServletContext context,String name) throws IOException {
		String rootDir=context.getRealPath("/shared/css/"+name);
		new File(rootDir).delete();
	}

	public static String getCSSFile(javax.servlet.ServletContext context,String name) throws IOException {
		String rootDir=context.getRealPath("/shared/css/"+name);
		StringBuffer result=new StringBuffer();
		BufferedReader reader=new BufferedReader(new InputStreamReader(new FileInputStream(new File(rootDir)),"Cp1251"));
		try{
			String line;
			while ((line=reader.readLine())!=null) result=result.append(line).append("\n");
		} finally {reader.close();}
		return result.toString();
	}

	public static void updCSSFile(javax.servlet.ServletContext context,String name,String content) throws IOException {
		String rootDir=context.getRealPath("/shared/css/"+name);
		BufferedWriter writer=new BufferedWriter(new OutputStreamWriter(new FileOutputStream(new File(rootDir)),"Cp1251"));
		try{
			writer.write(content);
		} finally {writer.close();}
	}

	public static void createCSSFile(javax.servlet.ServletContext context,String name) throws Exception {
		String rootDir=context.getRealPath("/shared/css");
		File dir=new File(rootDir);
		if (!dir.exists()) { 
			dir.mkdirs();
			try{
				executeCommand("/bin/chmod a+rx "+rootDir);
			} catch (Exception e) {}
		}
		rootDir=context.getRealPath("/shared/css/"+name+".css");
		new File(rootDir).createNewFile();
		try{
			executeCommand("/bin/chmod a+r "+rootDir);
		} catch (Exception e) {}
	}

	public static void executeCommand(String command) throws Exception {
		Runtime linux=Runtime.getRuntime();
		Process proc=linux.exec(command);
	}

}

  class dirFileFilter implements java.io.FileFilter {
    String rootDir=null;

    public dirFileFilter(String rootDir) {
      this.rootDir=rootDir;
    } 

    public boolean accept(File pathname) {
      if (!pathname.isDirectory()) return false; 
      String path=dirutils.getRelativePath(rootDir,pathname);
      if (path.equals(File.separator+"WEB-INF") || path.equals(File.separator+"shared"+File.separator+"interfaces")) return false;
      return true;
    }
  }

  class containerFileFilter implements java.io.FileFilter{
    public boolean accept(File pathname) {
      try{
      if (pathname.exists() && pathname.isFile() && pathname.getName().endsWith(".jsp")) {
        BufferedReader reader=new BufferedReader(new InputStreamReader(new FileInputStream(pathname),"Cp1251"));
	try{
  	  String line;
	  if (((line=reader.readLine())!=null) && (line.indexOf("<%-- Container Page --%>")>=0)) return true;  	    
	} finally {reader.close();}
      }
      } catch (Exception e) {}
      return false;
    }
  }

  class cssFileFilter implements java.io.FileFilter{
    public boolean accept(File pathname) {
      try{
      if (pathname.exists() && pathname.isFile() && pathname.getName().endsWith(".css")) return true; else return false;
      } catch (Exception e) {}
      return false;
    }
  }
