package pattern.sitebuilder;
import webJinn.exception.*;
import webJinn.*;
import webJinn.field.*;
import webJinn.sql.*;
import javax.servlet.http.*;
import javax.servlet.*;
import java.util.*;
import java.sql.*;
import java.io.*;

public class ResUpdatePage extends webJinn.wJPage implements webJinn.wJUpdatePage {
  protected webJinn.RequestParamsReader reader;
  protected SQLConnector connector;
  protected Connection connection;
  protected int contid;
  protected String conttype;
  protected Hashtable tags=new Hashtable();

  public ResUpdatePage(javax.servlet.ServletContext context) {
    super(context);
    this.connector=(SQLConnector)context.getAttribute("_Connector");
    connection=null;
  }

 protected webJinn.EntityRequestParamsReader getReader(javax.servlet.ServletContext context,EntityInfo entityInfo) {
    UploadManager manager = (UploadManager)context.getAttribute("_UploadManager");
    if (manager==null) return null;
    return new EntityRequestParamsReader(manager);
 }

 public void readRequestParams(HttpServletRequest request) {
   fields=new Hashtable();
   super.readRequestParams(request);
   try{
     contid = Integer.parseInt(((TextField)fields.get("contid")).getStringValue());
     conttype = ((TextField)fields.get("conttype")).getStringValue();
   } catch (Exception e) {}
   tags.clear();
 }

 public void reverseTransform(HttpServletRequest request) throws webJinn.exception.EntityTransactionException {
   try{
     fields=new Hashtable();
     tags.clear();
     contid = Integer.parseInt(request.getParameter("contid"));
     conttype = request.getParameter("conttype");
     processResources();
   } catch (Exception e) {}
 }

 public void connect() {
   disconnect();
   try {
     connection=connector.getConnection();
   } catch (SQLException e) {}
 }

 public void disconnect() {
   if (connection!=null)
   try{
     connection.close();
   } catch (SQLException e) {connection=null;}
 }

 public void directTransform() {
   try{
     setContainerTags();
   } catch (Exception e) {}
 }

 protected void doTransact() throws EntityTransactionException {
   Enumeration resources=tags.elements();
   while (resources.hasMoreElements()) {
     Resource res=(Resource)resources.nextElement();
     res.setField(connection,(webJinn.field.Field)fields.get(res.getName()));
   }   
 }

 private void setContainerTags() throws Exception {
   ResourceContainer rc=ResourceContainer.instanciate(conttype,context);
   rc.setContId(""+contid);
   Hashtable tags=rc.getResources();
   if (tags!=null) this.tags.putAll(tags);
 }

 private void processResources() throws Exception {
   Connection con=connector.getConnection();
   try{
     setContainerTags();
     Enumeration resources=tags.elements();

     while (resources.hasMoreElements()) {
       Resource res=(Resource)resources.nextElement();
       webJinn.field.Field field=res.getField(con);
       if (field!=null) fields.put(res.getName(),field);
     }
   } finally {try{con.close();}catch (Exception e) {}}
 }

 public Enumeration getTags() {
   return tags.elements();
 }

 public int getContId() {
   return contid;
 }
}