package pattern.sitebuilder;
import java.io.*;
import java.util.*;
import java.sql.*;
import webJinn.parser.parser;
import webJinn.parser.parser.Element;

public class PageContainer extends CodeContainer {
  protected String uri=null;
  protected String name=null;
  protected ItemTree tree=null;

  public PageContainer(javax.servlet.ServletContext context) {
    super(context);
    conttype="page";
    resourceTag="wJ:PageRes";
    tree=new ItemTree();
    tree.setSQLConnector(connector);
  }

  public void setContainerFile(File f) {
    String uri=dirutils.getRelativePath(rootDir,f);
    this.uri=uri.substring(0,uri.lastIndexOf(File.separator));
    if (uri.endsWith(File.separator)) uri=uri.substring(0,uri.length()-1);
    this.name=uri.substring(uri.lastIndexOf(File.separator)+1);
  }

  public void setURI(String val) {
    this.uri=val;
    if (uri.endsWith(File.separator)) uri=uri.substring(0,uri.length()-1);
  }

  public void setName(String val) {
    this.name=val;
  }

  public String getURI() {
    return this.uri;
  }

  public String getName() {
    return this.name;
  }

  public String getId() {
    return ""+getContainerID();
  }


  public void createNew(String pattern) {

    String uri=this.uri+File.separator+this.name;
    try{
      String code="";
      if (!pattern.equals("default")) {
        code=new PagePattern(context).getCode(pattern);
      }

      if (code==null) code="";

      StringBuffer content=new StringBuffer();
      /*Container definition*/
      content=content.append("<%-- Container Page --%>");
      /*Default jsp options...*/
      content=content.append("\n<%@ page contentType=\"text/html; charset=windows-1251\" %>");
      content=content.append("\n<%@ taglib uri=\"http://webjinn.saturn-r.ru/webjinn\" prefix=\"wJ\" %>");

      /*Container Properties*/
      content=content.append("\n<%-- Container Properties Start --%>");
      content=content.append("\n<wJ:PageSetup id='"+getContainerID()+"'/>");
//      content=content.append("\n<%request.setAttribute(\"_pageid\",new Integer("+getContainerID()+"));%>");
      content=content.append("\n<%-- Container Properties End --%>");

      /*Menu Header*/
      content=content.append("\n<%-- Menu Header Start --%>");
      content=content.append("\n<%-- Menu Header End --%>");

      /*Page Design*/
      content=content.append("\n<%-- Design Start --%>\n");
      content=content.append(code);
      content=content.append("\n<%-- Design End --%>");

      /*Menu Footer*/
      content=content.append("\n<%-- Menu Footer Start --%>");
      content=content.append("\n<%-- Menu Footer End --%>");
      File cont=new File(dirutils.getFullPath(rootDir,uri));
      saveToFile(cont,content.toString());


    } catch (Exception e) {}

  }

  public boolean isBounded() throws Exception {
      long id=getContainerID();
      Connection con=connector.getConnection();
      try{
       PreparedStatement st=con.prepareStatement("Select menu__id from _containers where record__id=?");
       st.setLong(1,id);
       ResultSet rs=st.executeQuery();
       if (!rs.next()) return false;
       if (rs.getInt(1)>0) return true; else return false;
      } finally {try{con.close();}catch (SQLException e) {}}
  }

  public boolean isBoundedToItem() throws Exception {
      long id=getContainerID();
      Connection con=connector.getConnection();
      try{
       PreparedStatement st=con.prepareStatement("Select menuitem__id from _containers where record__id=?");
       st.setLong(1,id);
       ResultSet rs=st.executeQuery();
       if (!rs.next()) return false;
       if (rs.getInt(1)>0) return true; else return false;
      } finally {try{con.close();}catch (SQLException e) {}}
  }


  public String getBoundItemName() throws Exception {
      long id=getContainerID();
      Connection con=connector.getConnection();
      try{
       PreparedStatement st=con.prepareStatement("Select _menuitems.name from _containers LEFT JOIN _menuitems on (_containers.menuitem__id=_menuitems.record__id) where _containers.record__id=?");
       st.setLong(1,id);
       ResultSet rs=st.executeQuery();
       if (!rs.next()) return null;
       return rs.getString(1);
      } finally {try{con.close();}catch (SQLException e) {}}
  }

  public String getBoundMenuName() throws Exception {
      long id=getContainerID();
      Connection con=connector.getConnection();
      try{
       PreparedStatement st=con.prepareStatement("Select _menus.name from _containers LEFT JOIN _menus on (_containers.menu__id=_menus.record__id) where _containers.record__id=?");
       st.setLong(1,id);
       ResultSet rs=st.executeQuery();
       if (!rs.next()) return null;
       return rs.getString(1);
      } finally {try{con.close();}catch (SQLException e) {}}
  }



  public String getBoundInterface() throws Exception {
      long id=getContainerID();
      Connection con=connector.getConnection();
      try{
       PreparedStatement st=con.prepareStatement("Select _interfaces.name from _containers LEFT JOIN _menus on (_containers.menu__id=_menus.record__id) LEFT JOIN _interfaces ON (_menus.interface__id=_interfaces.record__id) where _containers.record__id=?");
       st.setLong(1,id);
       ResultSet rs=st.executeQuery();
       if (!rs.next()) return null;
       return rs.getString(1);
      } finally {try{con.close();}catch (SQLException e) {}}
  }

  public void checkPageProperties() {
    String uri=this.uri+File.separator+this.name;
    File cont=new File(dirutils.getFullPath(rootDir,uri));
    String part=getPart(cont,"Container Properties");
    if (part!=null) {
      String[] tags={"wJ:PageSetup"};
      boolean[] hasBody={};
      parser p=new parser(part.toCharArray(),tags,hasBody);
      p.parse();
      if (p.elements!=null) 
       for (int i=0;i<p.elements.size();i++) {
        Element el = (Element)p.elements.get(i);
        if (el.type.equalsIgnoreCase("wJ:PageSetup")) {
          return;
        }
       }
    } else {part="";}
    part="<wJ:PageSetup id='"+getContainerID()+"'/>\n"+part.trim();
    setPart(cont,"Container Properties",part);
  }

  public void delete() {
    String uri=this.uri+File.separator+this.name;
    try{
      new File(dirutils.getFullPath(rootDir,uri)).delete();
      long id=getContainerID();
      Connection con=connector.getConnection();
      try{
       PreparedStatement st=con.prepareStatement("Delete from _containers where record__id=?");
       st.setLong(1,id);
       st.executeUpdate();
       st=con.prepareStatement("Delete from _siteresources where master__id=? and mastertype=?");
       st.setLong(1,id);
       st.setString(2,conttype);
       st.executeUpdate();
      } finally {try{con.close();}catch (SQLException e) {}}
    } catch (Exception e) {}
  }

  public void boundToMenu(String menuid) throws Exception {

    String uri=this.uri+File.separator+this.name;
    String itemid=tree.getParentId(menuid);
    if (itemid!=null && itemid.equals("-1")) itemid=null;

    String jspuri=tree.getMenuURI(menuid);
    if (!jspuri.endsWith("/")) jspuri=jspuri+"/";

    String itempath="null";
    if (itemid!=null) itempath=tree.getNodePath(Integer.parseInt(itemid));

    File cont=new File(dirutils.getFullPath(rootDir,uri));
    StringBuffer part=new StringBuffer();
//  part=part.append("<%request.setAttribute(\"_itempath\",\""+itempath+"\");%>");
    part=part.append("\n<jsp:include page=\""+jspuri+"header.jsp"+"\"/>");
    setPart(cont,"Menu Header",part.toString());
    part=new StringBuffer("\n<jsp:include page=\""+jspuri+"footer.jsp"+"\"/>");
    setPart(cont,"Menu Footer",part.toString());
    Connection con=connector.getConnection();
    try{
     con.createStatement().executeUpdate("Update _containers set menuitem__id=NULL,menu__id="+menuid+" where record__id="+getContainerID());
    } finally {try{con.close();}catch (SQLException e) {}}
    
  }



  public void boundToItem(String itemid) throws Exception {
    String uri=this.uri+File.separator+this.name;
    String menuid=tree.getMenuId(itemid);

    String jspuri=tree.getMenuURIByItem(itemid);
    if (!jspuri.endsWith("/")) jspuri=jspuri+"/";
    String itempath=tree.getNodePath(Integer.parseInt(itemid));

    File cont=new File(dirutils.getFullPath(rootDir,uri));
    StringBuffer part=new StringBuffer();
//  part=part.append("<%request.setAttribute(\"_itempath\",\""+itempath+"\");%>");
//  part=part.append("\n<%request.setAttribute(\"_itemid\",new Integer("+itemid+"));%>");
    part=part.append("\n<jsp:include page=\""+jspuri+"header.jsp"+"\"/>");
    setPart(cont,"Menu Header",part.toString());
    part=new StringBuffer("\n<jsp:include page=\""+jspuri+"footer.jsp"+"\"/>");
    setPart(cont,"Menu Footer",part.toString());
    Connection con=connector.getConnection();
    try{
     con.createStatement().executeUpdate("Update _containers set menuitem__id="+itemid+",menu__id="+menuid+" where record__id="+getContainerID());
    } finally {try{con.close();}catch (SQLException e) {}}
    
  }

  public Vector getDesignPages() {
   Vector result=new Vector(1);
   try{
     String uri=this.uri+File.separator+this.name;
     File cont=new File(dirutils.getFullPath(rootDir,uri));
     if (hasPart(cont,"Design")) result.add(cont);

     String part=getPart(cont,"Container Properties");
     if (part!=null) {
       String[] tags={"DesignPage"};
       boolean[] hasBody={true};
       parser p=new parser(part.toCharArray(),tags,hasBody);
       p.parse();
       if (p.elements!=null) 
        for (int i=0;i<p.elements.size();i++) {
         Element el = (Element)p.elements.get(i);
         if (el.type.equalsIgnoreCase("DesignPage") && el.body!=null) {
           String desPage=new String(el.body);
           if (desPage!=null && desPage.length()>0) {
             if (!desPage.startsWith("/")) desPage=this.uri+"/"+desPage;
             File f=new File(dirutils.getFullPath(rootDir,desPage));
             if (f.exists()) result.add(f);
           }
         }
        }
     }
   } catch (Exception e) {}
   return result;
  }

  protected File[] getContainerFiles() {
    Vector files=getDesignPages();
    File[] result=new File[files.size()];
    for (int i=0;i<files.size();i++)
      result[i]=(File)files.get(i);
    return result;
  }



  public long getContainerID() {
   try{
     String path=uri+File.separator+name;
     Connection con=connector.getConnection();
     try{
      PreparedStatement st=con.prepareStatement("Select record__id from _containers where filepath=?");
      st.setString(1,path);
      ResultSet rs=st.executeQuery();
      if (!rs.next()) {
         st=con.prepareStatement("Insert into _containers set filepath=?,name=?");
         st.setString(1,path);
         st.setString(2,name);
         st.executeUpdate();
         return ((org.gjt.mm.mysql.PreparedStatement)st).getLastInsertID();
      } else {
         return rs.getLong(1);
      }
     } finally {try{con.close();}catch (SQLException e) {}}
   } catch (Exception e) {return 0;}

  }

  public void setContId(String contid) { 
   super.setContId(contid);
   try{
     Connection con=connector.getConnection();
     try{
      ResultSet rs=con.createStatement().executeQuery("Select filepath from _containers where record__id="+contid);
      rs.next();
      setContainerFile(new File(dirutils.getFullPath(rootDir,rs.getString(1))));
     } finally {try{con.close();}catch (SQLException e) {}}
   } catch (Exception ee) {}
  }



}