package pattern.sitebuilder;
import java.io.*;

public class MenuPattern extends ContainerPattern {
  protected javax.servlet.ServletContext context;
  public MenuPattern(javax.servlet.ServletContext context) {
    this.context=context;
    setPatternDir(context.getRealPath(""),"shared/interfaces/_menupatterns");
  }
  protected void makePatternFiles(String name) {
    try{
      new File(patternDir+File.separator+name+File.separator+"header.code").createNewFile();
      new File(patternDir+File.separator+name+File.separator+"footer.code").createNewFile();
    } catch (Exception e) {}
  }
  public String getHeaderCode(String name) {
     return getCode(new File(patternDir+File.separator+name+File.separator+"header.code"));
  }

  public String getFooterCode(String name) {
     return getCode(new File(patternDir+File.separator+name+File.separator+"footer.code"));
  }

  public void setHeaderCode(String name,String code) {
     updateCode (new File(patternDir+File.separator+name+File.separator+"header.code"),code);
  }

  public void setFooterCode(String name,String code) {
     updateCode (new File(patternDir+File.separator+name+File.separator+"footer.code"),code);
  }

}
