package pattern.sitebuilder;
import java.io.*;
import java.util.*;
import java.sql.*;
import webJinn.parser.parser;
import webJinn.parser.parser.Element;

public class MenuContainer extends CodeContainer {

  protected long contid=-1;
  protected String menuId="-1";
  protected String interfaceid=null;
  protected ItemTree tree=null;

  public MenuContainer(javax.servlet.ServletContext context) {
    super(context);
    conttype="menu";
    resourceTag="wJ:MenuRes";
    tree=new ItemTree();
    tree.setSQLConnector(connector);
  }

  public void setContId(String contid) { 
   try{
    this.contid=Long.parseLong(contid);
    menuId=""+contid;
   } catch (Exception e) {}
  }

  public void setInterfaceId(String val) { 
    this.interfaceid=val;
  }

  public String getMenuURI() {
    return tree.getMenuURI(menuId);
  }

  public int getItemsCount() {
    return tree.getMenuItemsCount(menuId);
  }


  public void createNew(String name,String pattern,String itemId) throws Exception {
    Connection con=connector.getConnection();
    try{
      boolean hasParentMenu=true;
      PreparedStatement pst=con.prepareStatement("Insert into _menus set name=?,interface__id=?,item__id=?");
      pst.setString(1,name);
      pst.setInt(2,Integer.parseInt(interfaceid));
      if (itemId==null || Integer.parseInt(itemId)<0) {
        pst.setNull(3,java.sql.Types.NULL);
        hasParentMenu=false;
      } else {
        pst.setInt(3,Integer.parseInt(itemId));
      }
      pst.executeUpdate();
      String menuId=""+((org.gjt.mm.mysql.PreparedStatement)pst).getLastInsertID();
      String menuUri=tree.getMenuURI(menuId);
      String menuDir=rootDir+menuUri.replace('/',File.separatorChar);

      File f=new File(menuDir+File.separator+"header.jsp");
      f.getParentFile().mkdirs();
      f.createNewFile();
      StringBuffer content=new StringBuffer();
      /*Default jsp options...*/
      content=content.append("<%@ page contentType=\"text/html; charset=windows-1251\" %>");
      content=content.append("\n<%@ taglib uri=\"http://webjinn.saturn-r.ru/webjinn\" prefix=\"wJ\" %>");
      if (hasParentMenu) {
        String parentMenu=menuUri.substring(0,menuUri.lastIndexOf("/"))+"/header.jsp";
        content=content.append("\n<jsp:include page=\""+parentMenu+"\"/>");
      }

      content=content.append("\n<%-- Menu Properties Start --%>");
      content=content.append("\n<%request.setAttribute(\"_menuid\",new Integer("+menuId+"));%>");
      content=content.append("\n<%-- Menu Properties End --%>");

      content=content.append("\n<%-- Design Start --%>");
      if (!pattern.equals("default")) {
        MenuPattern pat=new MenuPattern(context);
        String filecontent=pat.getHeaderCode(pattern);
        if (filecontent!=null) content=content.append("\n").append(filecontent);
      }
      content=content.append("\n<%-- Design End --%>");
      saveToFile(f,content.toString());


      f=new File(menuDir+File.separator+"footer.jsp");
      f.getParentFile().mkdirs();
      f.createNewFile();
      content=new StringBuffer();
      /*Default jsp options...*/
      content=content.append("\n<%@ page contentType=\"text/html; charset=windows-1251\" %>");
      content=content.append("\n<%@ taglib uri=\"http://webjinn.saturn-r.ru/webjinn\" prefix=\"wJ\" %>");
      content=content.append("\n<%-- Menu Properties Start --%>");
      content=content.append("\n<%request.setAttribute(\"_menuid\",new Integer("+menuId+"));%>");
      content=content.append("\n<%-- Menu Properties End --%>");
      content=content.append("\n<%-- Design Start --%>");
      if (!pattern.equals("default")) {
        MenuPattern pat=new MenuPattern(context);
        String filecontent=pat.getFooterCode(pattern);
        if (filecontent!=null) content=content.append("\n").append(filecontent);
      }
      content=content.append("\n<%-- Design End --%>");
      if (hasParentMenu) {
        String parentMenu=menuUri.substring(0,menuUri.lastIndexOf("/"))+"/footer.jsp";
        content=content.append("\n<jsp:include page=\""+parentMenu+"\"/>");
      }

      saveToFile(f,content.toString());

    } finally {con.close();}
  }

  public long getContainerID() {
    return contid;
  }

  protected File[] getContainerFiles() {
    File[] result=new File[2];
    String menuUri=tree.getMenuURI(menuId);
    String menuPath=rootDir+menuUri.replace('/',File.separatorChar);
    result[0]=new File(menuPath+File.separator+"header.jsp");
    result[1]=new File(menuPath+File.separator+"footer.jsp");
    return result;
  }

}