package pattern.sitebuilder;
import java.sql.*;
import java.util.*;

public class ItemTree {

  protected webJinn.sql.SQLConnector connector=null;
  protected String treeTable="_menuitems";
  protected String idColumn="record__id";
  protected String conttype="item";
  protected String pathColumn="path";
  protected String menuUriRoot="/shared/interfaces";
  protected int levelLength=3;


  public String dropNode(int nodeId) {
    Connection con=null;
    try{
      con = connector.getConnection();
      Statement st = con.createStatement();
      String nodePath;
      if ((nodePath=getNodePath(st,nodeId))==null) return null;
      String interfaceid;
      if ((interfaceid=getInterfaceId(st,nodeId))==null) return null;

      Vector ids=new Vector();
      StringBuffer in=new StringBuffer();
      StringBuffer sql=new StringBuffer("Select "+idColumn+" from ").append(treeTable).append(" where ").append(pathColumn).append(" LIKE '").append(nodePath).append("%' and interface__id=").append(interfaceid);
      ResultSet rs=st.executeQuery(sql.toString());

      while (rs.next()) ids.add(rs.getString(1)); rs.close();
      for (int i=0;i<ids.size()-1;i++) 
        in=in.append((String)ids.get(i)).append(",");
      in=in.append((String)ids.get(ids.size()-1));

      sql=new StringBuffer("Delete from ").append(treeTable).append(" where ").append(pathColumn).append(" LIKE '").append(nodePath).append("%' and interface__id=").append(interfaceid);
      st.executeUpdate(sql.toString());

      sql=new StringBuffer("Delete from _siteresources").append(" where master__id IN (").append(in).append(")").append(" and mastertype='").append(conttype).append("'");
      st.executeUpdate(sql.toString());

      sql=new StringBuffer("Update _containers set menuitem__id=NULL").append(" where menuitem__id IN (").append(in).append(")");
      st.executeUpdate(sql.toString());

      if (nodePath.length()==levelLength) return null;
      return nodePath.substring(nodePath.length()-levelLength);
    }catch (Exception e) {return null;}
     finally {try{con.close();}catch (Exception e) {}}
  }

  /** Move node up within branch*/
  public void upNode(int nodeId) {
    Connection con=null;
    try{
      con = connector.getConnection();
      Statement st = con.createStatement();
      int currentPos = getNodePos(st,nodeId);
      if (currentPos<=1) return;      
      moveNode(st,nodeId,currentPos-1);
    }catch (Exception e) {return;}
     finally {try{con.close();}catch (Exception e) {}}
  }

  /** Move node down within branch*/
  public void downNode(int nodeId) {
    Connection con=null;
    try{
      con = connector.getConnection();
      Statement st = con.createStatement();
      String interfaceid=getInterfaceId(st,nodeId);
      int currentPos = getNodePos(st,nodeId);
      String path = getNodePath(st,nodeId);
      path=path.substring(0,path.length()-levelLength);
      int siblingCount=getChildrenCount(st,path,interfaceid);
      if (siblingCount<=currentPos) return;
      moveNode(st,nodeId,currentPos+1);
    }catch (Exception e) {return;}
     finally {try{con.close();}catch (Exception e) {}}
  }
  
  /** Returns children count of specified parent node (by parent id) */
  public int getChildrenCount(int parentId) {
    Connection con=null;
    try{
      con = connector.getConnection();
      Statement st = con.createStatement();
      String interfaceid=getInterfaceId(st,parentId);
      return getChildrenCount(st,getNodePath(st,parentId),interfaceid);
    }catch (Exception e) {return -1;}
     finally {try{con.close();}catch (Exception e) {}}
  }

  /** Returns children count of specified parent node (by parent id) */
  public int getMenuItemsCount(String menuId) {
    Connection con=null;
    try{
      con = connector.getConnection();
      Statement st=con.createStatement();
      ResultSet rs=st.executeQuery("Select count(record__id) from _menuitems where menu__id="+menuId);
      if (!rs.next()) return 0;
      return rs.getInt(1);
    }catch (Exception e) {return -1;}
     finally {try{con.close();}catch (Exception e) {}}
  }


  /** Returns node path by id (null if not found or error)*/
  public String getNodePath(int nodeId) {
    Connection con=null;
    try{
      con = connector.getConnection();
      Statement st = con.createStatement();
      return getNodePath(st,nodeId);
    }catch (Exception e) {return null;}
     finally {try{con.close();}catch (Exception e) {}}
  }

  public String getMenuId(String nodeId) {
    Connection con=null;
    try{
      con = connector.getConnection();
      Statement st = con.createStatement();
      return getMenuId(st,Integer.parseInt(nodeId));
    }catch (Exception e) {return null;}
     finally {try{con.close();}catch (Exception e) {}}
  }

  public String getMenuURI(String itemId,String interfaceid) {
    //menuUriRoot
    Connection con=null;
    try{
      con = connector.getConnection();
      Statement st = con.createStatement();
      if (itemId==null) itemId="-1";
      int nodeId=Integer.parseInt(itemId);
      String interfaceName=getInterfaceName(st,interfaceid);
      StringBuffer result=new StringBuffer(menuUriRoot).append("/").append(interfaceName);
      if (nodeId<=0) return result.toString();

      String path=getNodePath(st,nodeId);
      Vector parents=new Vector();
      while ((path=getParentPath(path))!=null) {
        parents.add(0,path);
      }
      for (int i=0;i<parents.size();i++) {
       result=result.append("/").append(getNodeName(st,(String)parents.get(i),interfaceid));
      }
      return result.toString();
    }catch (Exception e) {return null;}
     finally {try{con.close();}catch (Exception e) {}}
  }

  public String getMenuURIByItem(String itemId) {
    //menuUriRoot
    Connection con=null;
    try{
      con = connector.getConnection();
      Statement st = con.createStatement();
      int nodeId=Integer.parseInt(itemId);
      String interfaceName=getInterfaceName(st,nodeId);
      String interfaceid=getInterfaceId(st,nodeId);
      StringBuffer result=new StringBuffer(menuUriRoot).append("/").append(interfaceName);
      if (nodeId<=0) return result.toString();

      String path=getNodePath(st,nodeId);
      Vector parents=new Vector();
      while ((path=getParentPath(path))!=null) {
        parents.add(0,path);
      }
      for (int i=0;i<parents.size();i++) {
       result=result.append("/").append(getNodeName(st,(String)parents.get(i),interfaceid));
      }
      return result.toString();
    }catch (Exception e) {return null;}
     finally {try{con.close();}catch (Exception e) {}}
  }


  public String getMenuURI(String menuId) {
    //menuUriRoot
    Connection con=null;
    try{
      con = connector.getConnection();
      Statement st = con.createStatement();
      int nodeId;
      String itemId=getMenuItemId(st,menuId);
      if (itemId!=null) nodeId=Integer.parseInt(itemId); else nodeId=-1;
      String interfaceName=getInterfaceNameByMenuId(st,menuId);
      StringBuffer result=new StringBuffer(menuUriRoot).append("/").append(interfaceName);

      if (nodeId<=0) return result.toString();
      String interfaceid=getInterfaceId(st,nodeId);
      String path=getNodePath(st,nodeId);
      Vector parents=new Vector();
      parents.add(path);
      while ((path=getParentPath(path))!=null) {
        parents.add(0,path);
      }
      for (int i=0;i<parents.size();i++) {
       result=result.append("/").append(getNodeName(st,(String)parents.get(i),interfaceid));
      }
      return result.toString();
    }catch (Exception e) {return null;}
     finally {try{con.close();}catch (Exception e) {}}
  }


  public String getParentId(String menuId) throws Exception{
    if (menuId==null || menuId.length()==0) return "-1";
    Connection con=null;
    try{
      con = connector.getConnection();
      Statement st = con.createStatement();
      ResultSet rs=st.executeQuery("Select item__id from _menus where record__id="+menuId);
      rs.next();
      return rs.getString(1);
    }catch (Exception e) {return null;}
     finally {try{con.close();}catch (Exception e) {}}
  }

  public int getNodeLevel(String path) {
    if (path==null || path.length()==0) return 0;
    return Math.round(path.length()/levelLength);
  }

  /**Returns new path should be used when inserting new children into specified parent branch */
  public String getNewPath(String menuId) {
    Connection con=null;
    try{
      con = connector.getConnection();
      Statement st = con.createStatement();
      String interfaceid=getInterfaceIdByMenuId(st,menuId);
      int parentId=Integer.parseInt(getMenuItemId(st,menuId));
      String parentPath=null;
      if (parentId>0) parentPath=getNodePath(st,parentId);
      String childrenCount=""+(getChildrenCount(st,parentPath,interfaceid)+1);
      if (parentPath==null) parentPath="";
      StringBuffer result=new StringBuffer(parentPath);      
      int nullCount=levelLength-childrenCount.length();
      if (nullCount<0) return null;
      for (int i=0;i<nullCount;i++)
        result=result.append('0');
      result=result.append(childrenCount);
      return result.toString();
    } catch (Exception e) {return null;}
      finally {try{con.close();}catch (Exception e) {}}
  }



  /*Class utilites - private methods*/

   private int getChildrenCount(Statement st,String parentPath,String interfaceid) throws Exception {
    if (parentPath==null) parentPath="";
    StringBuffer like=new StringBuffer(parentPath);
    for (int i=0;i<levelLength;i++)
      like=like.append('_');
    StringBuffer sql=new StringBuffer().append("Select Count(").append(idColumn).append(") from ").append(treeTable).append(" where interface__id=").append(interfaceid).append(" and ").append(pathColumn).append(" LIKE '").append(like).append("'");    
    ResultSet rs = st.executeQuery(sql.toString());
    rs.next();
    int result=rs.getInt(1);
    rs.close();
    return result;
  }

   private int getChildrenCount(Statement st,int parentId) throws Exception {
    String parentPath=getNodePath(st,parentId);
    String interfaceid=getInterfaceId(st,parentId);

    StringBuffer like=new StringBuffer(parentPath);
    for (int i=0;i<levelLength;i++)
      like=like.append('_');
    StringBuffer sql=new StringBuffer().append("Select Count(").append(idColumn).append(") from ").append(treeTable).append(" where interface__id=").append(interfaceid).append(" and ").append(pathColumn).append(" LIKE '").append(like).append("'");    
    ResultSet rs = st.executeQuery(sql.toString());
    rs.next();
    int result=rs.getInt(1);
    rs.close();
    return result;
  }

  
  private String getNodePath(Statement st,int nodeId) throws Exception {
    StringBuffer sql=new StringBuffer();
    sql=sql.append("Select ").append(pathColumn).append(" from ").append(treeTable).append(" where ").append(idColumn).append("=").append(nodeId);
    ResultSet rs = st.executeQuery(sql.toString());
    rs.next();
    String result=rs.getString(1);
    rs.close();
    return result;
  }

  private int getNodeId(Statement st,String nodePath,String interfaceid) throws Exception {
    StringBuffer sql=new StringBuffer();
    sql=sql.append("Select ").append(idColumn).append(" from ").append(treeTable).append(" where ").append(pathColumn).append("=").append(nodePath).append(" and interface__id=").append(interfaceid);
    ResultSet rs = st.executeQuery(sql.toString());
    rs.next();
    int result=rs.getInt(1);
    rs.close();
    return result;
  }

  private String getNodeName(Statement st,String nodePath,String interfaceid) throws Exception {
    StringBuffer sql=new StringBuffer();
    sql=sql.append("Select name").append(" from ").append(treeTable).append(" where ").append(pathColumn).append("=").append(nodePath).append(" and interface__id=").append(interfaceid);
    ResultSet rs = st.executeQuery(sql.toString());
    rs.next();
    String result=rs.getString(1);
    rs.close();
    return result;
  }

  private String getParentPath(String nodePath) {
    if (nodePath==null || nodePath.length()<=levelLength) return null;
    return nodePath.substring(0,nodePath.length()-levelLength);
  }


  private String getInterfaceId(Statement st,int nodeId) throws Exception {
    StringBuffer sql=new StringBuffer();
    sql=sql.append("Select interface__id").append(" from ").append(treeTable).append(" where ").append(idColumn).append("=").append(nodeId);
    ResultSet rs = st.executeQuery(sql.toString());
    rs.next();
    String result=rs.getString(1);
    rs.close();
    return result;
  }

  private String getMenuId(Statement st,int nodeId) throws Exception {
    StringBuffer sql=new StringBuffer();
    sql=sql.append("Select menu__id").append(" from ").append(treeTable).append(" where ").append(idColumn).append("=").append(nodeId);
    ResultSet rs = st.executeQuery(sql.toString());
    rs.next();
    String result=rs.getString(1);
    rs.close();
    return result;
  }

  private String getMenuItemId(Statement st,String menuId) throws Exception {
    StringBuffer sql=new StringBuffer();
    sql=sql.append("Select item__id from _menus where record__id=").append(menuId);
    ResultSet rs = st.executeQuery(sql.toString());
    if (!rs.next()) return "-1";
    String result=rs.getString(1);
    if (result==null) result="-1";
    rs.close();
    return result;
  }


  private String getInterfaceName(Statement st,int nodeId) throws Exception {
    StringBuffer sql=new StringBuffer();
    sql=sql.append("Select _interfaces.name from _menuitems LEFT JOIN _interfaces ON (_menuitems.interface__id=_interfaces.record__id) where _menuitems.record__id=").append(nodeId);
    ResultSet rs = st.executeQuery(sql.toString());
    rs.next();
    String result=rs.getString(1);
    rs.close();
    return result;
  }

  private String getInterfaceName(Statement st,String interfaceid) throws Exception {
    StringBuffer sql=new StringBuffer();
    sql=sql.append("Select name from _interfaces where record__id=").append(interfaceid);
    ResultSet rs = st.executeQuery(sql.toString());
    rs.next();
    String result=rs.getString(1);
    rs.close();
    return result;
  }

  private String getInterfaceNameByMenuId(Statement st,String menuId) throws Exception {
    StringBuffer sql=new StringBuffer();
    sql=sql.append("Select _interfaces.name from _menus LEFT JOIN _interfaces ON (_menus.interface__id=_interfaces.record__id) where _menus.record__id=").append(menuId);
    ResultSet rs = st.executeQuery(sql.toString());
    rs.next();
    String result=rs.getString(1);
    rs.close();
    return result;
  }

  private String getInterfaceIdByMenuId(Statement st,String menuId) throws Exception {
    StringBuffer sql=new StringBuffer();
    sql=sql.append("Select _interfaces.record__id from _menus LEFT JOIN _interfaces ON (_menus.interface__id=_interfaces.record__id) where _menus.record__id=").append(menuId);
    ResultSet rs = st.executeQuery(sql.toString());
    rs.next();
    String result=rs.getString(1);
    rs.close();
    return result;
  }


  private int getNodePos(Statement st,int nodeId) throws Exception {
    StringBuffer sql=new StringBuffer();
    sql=sql.append("Select ").append(pathColumn).append(" from ").append(treeTable).append(" where ").append(idColumn).append("=").append(nodeId);
    ResultSet rs = st.executeQuery(sql.toString());
    rs.next();
    String path=rs.getString(1);
    String pos = path.substring(path.length()-levelLength);
    return Integer.parseInt(pos.toString());
  }
  
  /*Change node path string as well as do change all this node children path strings*/
  private void moveNode(Statement st,int nodeId,int pos) throws Exception {

    String interfaceid;
    if ((interfaceid=getInterfaceId(st,nodeId))==null) return;
    
    String oldPath = getNodePath(st,nodeId);
    if (oldPath==null) return;
    String Pos=""+pos;
    while (Pos.length()<levelLength) 
      Pos="0"+Pos;
    
    String newPath;
    if (oldPath.length()==levelLength) newPath=Pos; else newPath=oldPath.substring(0,oldPath.length()-levelLength)+Pos;
    
    StringBuffer sql=new StringBuffer();
    sql=sql.append("Select ").append(pathColumn).append(",").append(idColumn).append(" from ").append(treeTable).append(" where interface__id=").append(interfaceid).append(" and (").append(pathColumn).append(" LIKE '").append(oldPath).append("%'").append(" or ").append(pathColumn).append(" LIKE '").append(newPath).append("%')");
    ResultSet rs = st.executeQuery(sql.toString());
    String path;
    int id;
    while (rs.next()) {
      path=rs.getString(1);
      id = rs.getInt(2);
      sql=new StringBuffer("Update ").append(treeTable).append(" set ").append(pathColumn).append("='");
      if (path.startsWith(oldPath)) {
        path=newPath+path.substring(oldPath.length());
      }  else {
        path=oldPath+path.substring(newPath.length());
      }
      sql=sql.append(path).append("' where ").append(idColumn).append("=").append(id);
      st.executeUpdate(sql.toString());
    } 
    rs.close();
  }
  
  public void setSQLConnector(webJinn.sql.SQLConnector connector) {
    this.connector=connector;
  }
  
  public webJinn.sql.SQLConnector getSQLConnector() {
    return connector;
  }
  
  public String getTreeTable() {
    return treeTable;
  }

  public String getIdColumn() {
    return idColumn;
  }
  
  public String getPathColumn() {
    return pathColumn;
  }

  public int getLevelLength() {
    return levelLength;
  }
  


}
