package pattern.sitebuilder;
import java.io.*;
import java.util.*;
import java.sql.*;
import webJinn.parser.parser;
import webJinn.parser.parser.Element;

public class ItemContainer extends ResourceContainer {
  protected String itemId="-1";
  protected String interfaceid=null;
  protected ItemTree tree=null;

  public ItemContainer(javax.servlet.ServletContext context) {
    super(context);
    conttype="item";
    resourceTag="wJ:ItemRes";
    tree=new ItemTree();
    tree.setSQLConnector(connector);

  }

  public void setContId(long contid) { 
    super.setContId(contid);
    itemId=""+contid;
  }

  public void setContId(String contid) { 
   super.setContId(contid);
   itemId=""+contid;
  }

  public void setInterfaceId(String val) { 
    this.interfaceid=val;
  }

  public String getMenuURI() {
    return tree.getMenuURI(itemId,interfaceid);
  }

  public void addChild(String menuId,String name) throws Exception {
    String parentid=tree.getParentId(menuId);
    String path=tree.getNewPath(menuId);
    Connection con=connector.getConnection();
    try{
      PreparedStatement pst=con.prepareStatement("Insert into _menuitems set name=?,path=?,menu__id=?,interface__id=?");
      pst.setString(1,name);
      pst.setString(2,path);
      pst.setInt(3,Integer.parseInt(menuId));
      pst.setInt(4,Integer.parseInt(interfaceid));
      pst.executeUpdate();
    } finally {con.close();}
  }



  public void dropNode() throws Exception {
     tree.dropNode(Integer.parseInt(itemId));
  }

  public ResultSet getMenu(Statement st) throws Exception {
     if (contid>=0) return st.executeQuery("Select _menus.record__id,_menus.name from _menus LEFT JOIN _menuitems ON (_menuitems.record__id=_menus.item__id) where _menuitems.record__id="+itemId);
     else {
      String sql="Select _menus.record__id,_menus.name from _menus where item__id IS NULL and interface__id="+interfaceid;
      return st.executeQuery(sql);	
     }
  }

  public void upNode() throws Exception {
     tree.upNode(Integer.parseInt(itemId));
  }

  public void downNode() throws Exception {
     tree.downNode(Integer.parseInt(itemId));
  }

  public int getNodeLevel(String path) throws Exception {
     return tree.getNodeLevel(path);
  }

  public int getChildrenCount(int nodeId) {
    return tree.getChildrenCount(nodeId);
  }
  protected File[] getContainerFiles() {
    Vector files=new Vector();	
    String menuUri=tree.getMenuURIByItem(itemId);
    String menuPath=rootDir+menuUri.replace('/',File.separatorChar);
    files.add(new File(menuPath+File.separator+"header.jsp"));
    files.add(new File(menuPath+File.separator+"footer.jsp"));

    try{
      Connection con=connector.getConnection();
      try{
       ResultSet rs=con.createStatement().executeQuery("Select filepath from _containers where menuitem__id="+contid);
       while (rs.next()) {
         files.add(new File(rootDir+File.separator+rs.getString(1)));
       }
      } finally {try{con.close();}catch (SQLException e) {}}
    } catch (Exception e) {}    
    File[] result=new File[files.size()];
    for (int i=0;i<files.size();i++)
      result[i]=(File)files.get(i);
    return result;
  }

  public long getContainerID() {
    return contid;
  }
}
