package pattern.sitebuilder;
import java.io.*;
import java.util.*;
import java.sql.*;
import webJinn.parser.parser;
import webJinn.parser.parser.Element;

public abstract class CodeContainer extends ResourceContainer{

  public CodeContainer(javax.servlet.ServletContext context) {
    super(context);
  }


  protected String getPart(File codeFile,String name) {
   try{
     StringBuffer result=new StringBuffer();
     BufferedReader reader=new BufferedReader(new InputStreamReader(new FileInputStream(codeFile),"Cp1251"));
     try{
       String line;
       boolean isPart=false;
       while ((line=reader.readLine())!=null) {
        if (line.indexOf("<%-- "+name+" Start --%>")>=0) {
          isPart=true;
          continue;
        }
        if (line.indexOf("<%-- "+name+" End --%>")>=0) {
          isPart=false;
          break;
        }
        if (isPart) result=result.append(line).append("\n");
       }
     } finally {reader.close();}
     return result.toString();
   } catch (Exception e) {return "";}
  }

  protected boolean hasPart(File codeFile,String name) {
   try{
     boolean hasStart=false;
     boolean hasEnd=false;
     BufferedReader reader=new BufferedReader(new InputStreamReader(new FileInputStream(codeFile),"Cp1251"));
     try{
       String line;
       while ((line=reader.readLine())!=null) {
        if (line.indexOf("<%-- "+name+" Start --%>")>=0) {
          hasStart=true;
          continue;
        }
        if (line.indexOf("<%-- "+name+" End --%>")>=0 && hasStart) {
          hasEnd=true;
          break;
        }
       }
     } finally {reader.close();}
     if (hasStart && hasEnd) return true; 
   } catch (Exception e) {}
   return false;
  }


  protected void setPart(File codeFile,String name,String code) {
    if (code==null) code="";
    try{
      StringBuffer file=new StringBuffer();
      BufferedReader reader=new BufferedReader(new InputStreamReader(new FileInputStream(codeFile),"Cp1251"));
      try{
        String line;
        boolean isPart=false;
        while ((line=reader.readLine())!=null) {
         if (line.indexOf("<%-- "+name+" Start --%>")>=0) {
           file=file.append(line).append("\n").append(code);
           isPart=true;
           continue;
         }
         if (line.indexOf("<%-- "+name+" End --%>")>=0) {
           file=file.append("\n").append(line).append("\n");
           isPart=false;
           continue;
         }
         if (!isPart) file=file.append(line).append("\n");
        }

       } finally {reader.close();}
       saveToFile(codeFile,file.toString().trim());
    } catch (Exception e) {}
  }

  protected void saveToFile(File container,String content) {
    try{
      if (content==null) content="";
      if (!container.exists()) {
        container.getParentFile().mkdirs();
        container.createNewFile();
      }
      BufferedWriter writer=new BufferedWriter(new OutputStreamWriter(new FileOutputStream(container),"Cp1251"));
      try{
        writer.write(content);
      } finally {writer.close();}
    } catch (Exception e) {}
  }

  public String getCode(String uri) {
    File cont=new File(dirutils.getFullPath(rootDir,uri));
    return getPart(cont,"Design");
  }
  public void setCode(String uri,String code) {
    File cont=new File(dirutils.getFullPath(rootDir,uri));
    setPart(cont,"Design",code);
  }

  public HashSet getLinkedCSS(File cont,String partName) {
   HashSet result=new HashSet();
   try{
     String part=getPart(cont,partName);
     if (part!=null) {
       String[] tags={"wJ:CSSLink"};
       boolean[] hasBody={false};
       parser p=new parser(part.toCharArray(),tags,hasBody);
       p.parse();
       if (p.elements!=null) 
        for (int i=0;i<p.elements.size();i++) {
         Element el = (Element)p.elements.get(i);
         if (el.type.equalsIgnoreCase("wJ:CSSLink")) {
           String url=el.getAttribute("url");
           if (url!=null) result.add(url);
         }
        }
     }
   } catch (Exception e) {}
   return result;
  }

  public void setLinkedCSS(File cont,String partName,HashSet uris) {
   try{
     String part=getPart(cont,partName);
     if (part!=null) {
       String[] tags={"wJ:CSSLink"};
       boolean[] hasBody={false};
       parser p=new parser(part.toCharArray(),tags,hasBody);
       p.parse();
       StringBuffer partCont=new StringBuffer();
       if (p.elements!=null) 
        for (int i=0;i<p.elements.size();i++) {
         Element el = (Element)p.elements.get(i);
         if (el.type.equalsIgnoreCase("text") && el.body!=null) partCont=partCont.append(el.body);
        }
       if (uris!=null) {
         Iterator it=uris.iterator();
         partCont=new StringBuffer(partCont.toString().trim()).append("\n");
         while (it.hasNext()) {
           partCont=partCont.append("<wJ:CSSLink url='").append((String)it.next()).append("'/>");
           if (it.hasNext()) partCont=partCont.append("\n");
         }
       }
       setPart(cont,partName,partCont.toString());
     }
   } catch (Exception e) {}

  }


}