package org.webjinn.cms.model.xml;
import org.w3c.dom.*;
import org.webjinn.cms.model.*;
import org.apache.xerces.parsers.DOMParser;
import java.util.Vector;


/** Provides access to the CMS tree */
public class XMLCMSTree {
	
	/** The url of an xml file that stores CMS tree */
	private String fileURI;
  /** DOM representation of the CMS tree */
	private Document doc;

	private Document getDOMTree() {
		try{
			DOMParser parser = new DOMParser();
			return parser.parse(fileURI);
		} catch (Exception e) {
			return null;
		}
	}

	public XMLCMSTree(String fileURI) {
		this.fileURI=fileURI;
		doc = getDOMTree();
	}
	
  /** Retrieves array of interfaces */	
	public Interface[] getInterfaces() {
		if (doc!=null) {
			Element root = doc.getDocumentElement();
			NodeList interfaces = 
				root.getElementsByTagName(XMLConstants.InterfaceTagName);
			int length=interfaces.length();
			Interface[] result = new Interface[length];

			for (int i=0;i<length;i++) 
				result[i] = Utils.toInterface(interfaces.item(i));
			return result;	
		} else {
			return null;
		}
	}

	/** Retrieves array of pages */
	public Page[] getPages() {
	}

	/** Adds new interface to the tree */
	public void addInterface(Interface in);

  /** Removes an interface from the tree */
	public void removeInterface(Interface in);

  /** Adds new page information to the tree */
  public void addPage(Page page);

  /** Removes a page from the tree */
	public void removePage(Page page);
	
  /** Tests if uri given corresponds to a tree page */
	public boolean isTreePage(String uri);

  /** Associates a Menu with the Item element 
	 * (adds the Menu element as a child of the Item element) */
  public void addMenu(Menu menu, Item item); 	

	/** Adds given Item element as a child of the Menu element */
	public void addItem(Menu menu, Item item);

	/** Moves an Item element one position up or down 
	 * within the associated Menu */
	public void moveItem(Item item, boolean up);

	/** Wraps the page according to the state of the
	 * tree */
	public void wrap(Page page);
	
	/** Synchronizes CMS tree with actual site content (files) */
	public void synchronize();

}
