package org.webjinn.cms.model.xml;
import org.w3c.dom.*;
import org.webjinn.cms.model.*;

/** Set of useful auxiliaritity functions */
public class Utils {

	public static XMLInterfaceImpl toInterface(Node node) {
		if (node==null || 
				node.getNodeType()!=Node.ELEMENT_NODE ||
				!node.getNodeName().equals(XMLConstants.InterfaceTagName))
			return null;
		String name = getAttributeValue(node,"name");
		String descr = getAttributeValue(node,"description");
		return new XMLInterfaceImpl(name,descr,node);
	}


	/** Returns attribute value of a node. null if no attribute found */
	public static String getAttributeValue(Node node, String attrName) {
		if (node==null || attrName==null) return null;
		NamedNodeMap attrs = node.getAttributes();
		Node attr = attrs.getNamedItem(attrName);
		if (attr!=null) return attr.getNodeValue();
		return null;
	}
}

