package org.webjinn.cms.model;
import java.io.File;

/** Implementation of the CSSFile interface */
public class CSSFileImpl implements CSSFile {
	
  /** url of the CSS file */
	private String url;
  /** file: uri of the css file (if exists) */ 
	private String fileURI;

	public CSSFileImpl(String url, String fileURI) {
		this.url = url;
		this.fileURI = fileURI;
	}

	/** Returns css file URL */
	public String getURL() {
		return url; 
	}

	/** Returns css file or null if not possible */
	public File getFile() {
    try{
			return new File(fileURI);
		} catch (Exception e) {
			return null;
		}	
	}
}
