package org.webjinn.cms.model;
import java.io.File;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.FileInputStream;
import java.io.BufferedWriter;
import java.io.OutputStreamWriter;
import java.io.FileOutputStream;

/** Abstract Page Implementation */
public abstract class AbstractPage implements Page {

	/** file URI */
	protected String fileURI;
	protected InterfaceTreeElement associated;


	public AbstractPage(String fileURI, InterfaceTreeElement associated) {
		this.fileURI=fileURI;
		this.associated = associated;
	}

	/** Returns file URI to the page */
	public String getFileURI() {
		return fileURI;
	}

	/** Retrieves content of the page file */
	public String getPageContent() {
		try{
			StringBuffer result=new StringBuffer();
			File pageFile = new File(fileURI);
			BufferedReader reader=new BufferedReader(new InputStreamReader(new FileInputStream(codeFile),"Cp1251"));
			try{
				String line;
				boolean isContent=true;
				while ((line=reader.readLine())!=null) {
					if (line.indexOf(Constants.generatedStart)>=0) {
						isContent=false;
						continue;
					}
					if (line.indexOf(Constants.generatedEnd)>=0) {
						isContent=true;
						continue;
					}
					if (isContent) result=result.append(line).append("\n");
				}
			} finally {reader.close();}
			return result.toString();
		} catch (Exception e) {return "";}
	}

	public void setPageContent(String content) {
		try{
			if (content==null) content="";
			File container = new File(fileURI);
			if (!container.exists()) {
				container.getParentFile().mkdirs();
				container.createNewFile();
			}
			BufferedWriter writer=new BufferedWriter(new OutputStreamWriter(new FileOutputStream(container),"Cp1251"));
			try{
				writer.write(content);
			} finally {writer.close();}
		} catch (Exception e) {}
	}

	/** Returns menu/item element associated with the page */
	public InterfaceTreeElement getAssociatedElement() {
		return associated;
	}

}
