package org.webjinn.cms.model;

/** Represents Menu element of the interface tree */
public interface Menu 
	extends CMSTreeNode, InterfaceTreeElement, AttributeContainer, CSSFilesContainer {

	/** Returns header string associated with the menu */
	public String getHeader();

	/** Returns footer string associated with the menu */
	public String getFooter();

	/** Sets new header into the Menu */
	public void setHeader(String header);
	
	/** Sets new footer into the Menu */
	public void setFooter(String footer);

  /** Returns associated (parent) Item element 
	 * (or null if it is the root menu) */
  public Item getParentItem();

  /** Returns nested Item elements */
  public Item[] getChildItems(); 

  /** Returns child Item with the name specified or null if not found */
  public Item getChildItem(String itemName); 
	

	/** Adds new Item element as a child of this Menu element.
	 * itemName must not be empty or null and must be unique among
	 * names of all children Items of this Menu */
	public void addItem(String itemName);

	/** Removes Item from the list of children of this Menu
	 * as well as from the tree. Do nothing if Item is not 
	 * a child of this Menu */
	public void removeItem(Item item);
	
}
