package org.webjinn.cms.model;

/** Represents container that is 
 * able to store attributes */
public interface AttributeContainer {

	/** Retrieves a list of attributes stored in the container */
	public Attribute[] getAttributes();

	/** Retrieves attribute from the container by its name */
	public Attribute getAttribute(String attrName);

	/** Adds an attribute to the container. 
	 * Does nothing if attribute with attrName already exists */
	public void addAttribute(String attrName, String attrDescr, String attrVal);

	/** Removes an attribute from the container.
	 * Does nothing if argument attribute is not an attribute
	 * of this container */
	public void removeAttribute(Attribute attr);

}
