/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.ddd.xml;

import edu.neu.ccs.ddd.Field;
import edu.neu.ccs.ddd.MetaData;
import edu.neu.ccs.ddd.MetaDataProvider;
import edu.neu.ccs.ddd.StdField;
import edu.neu.ccs.ddd.StdGroup;
import edu.neu.ccs.ddd.StdMetaData;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class XMLMetaDataProvider
implements MetaDataProvider {
    public static final String NAMESPACE = "stp";
    public static final String GLOBALTAG = "global";
    public static final String GROUPSTAG = "groups";
    public static final String GROUPTAG = "group";
    public static final String FIELDSTAG = "fields";
    public static final String FIELDTAG = "field";
    public static final String FIELDREFTAG = "fieldref";
    public static final String ATTRIBUTETAG = "attribute";
    private MetaData metaData = new StdMetaData();
    private String URL;

    public XMLMetaDataProvider(String string) {
        this.URL = string;
        this.metaData = null;
    }

    public MetaData getMetaData() {
        block2: {
            if (this.metaData != null) break block2;
            try {
                this.metaData = this.load(this.URL);
            }
            catch (Exception exception) {}
        }
        return this.metaData;
    }

    public void refresh() {
        this.metaData = null;
    }

    protected MetaData load(String string) throws Exception {
        this.URL = string;
        Document document = this.getDocument(string);
        Map map = this.getAttributes(document);
        Map map2 = this.getFields(document);
        Map map3 = this.getGroups(document, map2);
        StdMetaData stdMetaData = new StdMetaData();
        stdMetaData.setAttributes(map);
        stdMetaData.setGroups(map3);
        return stdMetaData;
    }

    protected Document getDocument(String string) throws Exception {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        return documentBuilder.parse(string);
    }

    protected Map getAttributes(Document document) {
        NodeList nodeList = document.getElementsByTagName(this.getTagName(NAMESPACE, GLOBALTAG));
        Hashtable hashtable = new Hashtable();
        int n = 0;
        while (n < nodeList.getLength()) {
            if (nodeList.item(n) instanceof Element) {
                this.fillAttributes((Element)nodeList.item(n), hashtable);
            }
            ++n;
        }
        return hashtable;
    }

    protected Map getFields(Document document) {
        Hashtable<String, StdField> hashtable = new Hashtable<String, StdField>();
        NodeList nodeList = document.getElementsByTagName(this.getTagName(NAMESPACE, FIELDSTAG));
        int n = 0;
        while (n < nodeList.getLength()) {
            if (nodeList.item(n) instanceof Element) {
                NodeList nodeList2 = ((Element)nodeList.item(n)).getElementsByTagName(this.getTagName(NAMESPACE, FIELDTAG));
                int n2 = 0;
                while (n2 < nodeList2.getLength()) {
                    Element element;
                    String string;
                    if (nodeList2.item(n2) instanceof Element && (string = (element = (Element)nodeList2.item(n2)).getAttribute("name")) != null) {
                        StdField stdField = new StdField(string);
                        Hashtable hashtable2 = new Hashtable();
                        this.fillAttributes(element, hashtable2);
                        Enumeration enumeration = hashtable2.keys();
                        while (enumeration.hasMoreElements()) {
                            String string2 = (String)enumeration.nextElement();
                            String string3 = (String)hashtable2.get(string2);
                            stdField.addAttribute(string2, string3);
                        }
                        hashtable.put(string, stdField);
                    }
                    ++n2;
                }
            }
            ++n;
        }
        return hashtable;
    }

    protected Map getGroups(Document document, Map map) {
        Hashtable<String, StdGroup> hashtable = new Hashtable<String, StdGroup>();
        NodeList nodeList = document.getElementsByTagName(this.getTagName(NAMESPACE, GROUPSTAG));
        int n = 0;
        while (n < nodeList.getLength()) {
            if (nodeList.item(n) instanceof Element) {
                NodeList nodeList2 = ((Element)nodeList.item(n)).getElementsByTagName(this.getTagName(NAMESPACE, GROUPTAG));
                int n2 = 0;
                while (n2 < nodeList2.getLength()) {
                    Element element;
                    String string;
                    if (nodeList2.item(n2) instanceof Element && (string = (element = (Element)nodeList2.item(n2)).getAttribute("name")) != null) {
                        StdGroup stdGroup = new StdGroup(string);
                        NodeList nodeList3 = element.getElementsByTagName(this.getTagName(NAMESPACE, FIELDREFTAG));
                        int n3 = 0;
                        while (n3 < nodeList3.getLength()) {
                            Element element2;
                            String string2;
                            if (nodeList3.item(n3) instanceof Element && (string2 = (element2 = (Element)nodeList3.item(n3)).getAttribute("name")) != null && map.get(string2) != null) {
                                stdGroup.addField((Field)map.get(string2));
                            }
                            ++n3;
                        }
                        hashtable.put(string, stdGroup);
                    }
                    ++n2;
                }
            }
            ++n;
        }
        return hashtable;
    }

    protected void fillAttributes(Element element, Map map) {
        NodeList nodeList = element.getChildNodes();
        String string = this.getTagName(NAMESPACE, ATTRIBUTETAG);
        int n = 0;
        while (n < nodeList.getLength()) {
            if (nodeList.item(n) instanceof Element && string.equals(nodeList.item(n).getNodeName())) {
                Element element2 = (Element)nodeList.item(n);
                String string2 = element2.getAttribute("name");
                String string3 = element2.getAttribute("value");
                if (string2 != null && string3 != null) {
                    map.put(string2, string3);
                }
            }
            ++n;
        }
    }

    private String getTagName(String string, String string2) {
        String string3 = string2;
        if (string != null && string.length() > 0) {
            string3 = string + ":" + string3;
        }
        return string3;
    }
}

