/*
 * Decompiled with CFR 0.152.
 */
package org.webjinn.utils;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class Parser {
    private char[] file;
    private String[] tags;
    private int pos = 0;
    private Vector elements;
    private String curTagType;
    private String curAttributes;
    private char[] curBody;
    private boolean[] hasBodies;

    public Parser(String string, String[] stringArray, boolean[] blArray) {
        this.file = this.getChars(string);
        this.tags = stringArray;
        this.hasBodies = blArray;
    }

    public Parser(char[] cArray, String[] stringArray, boolean[] blArray) {
        this.file = cArray;
        this.tags = stringArray;
        this.hasBodies = blArray;
    }

    public Element[] getElements() {
        if (this.elements != null) {
            return this.elements.toArray(new Element[0]);
        }
        return new Element[0];
    }

    protected int getNextPoint(int n) {
        if (n == 0) {
            int n2;
            int n3;
            int n4;
            while (true) {
                if ((n4 = this.getNextPosition('<', false, true)) == -1) {
                    return -1;
                }
                ++this.pos;
                if (this.getNextPosition(' ', false, false) == -1) continue;
                int n5 = this.pos;
                while (this.pos < this.file.length && (Character.isLetterOrDigit(this.file[this.pos]) || this.file[this.pos] == '_') || this.file[this.pos] == ':') {
                    ++this.pos;
                }
                if (n5 != this.pos && this.isMatchedTag(n5, n3 = this.pos) && (n2 = this.getNextPosition('>', false, true)) != -1) break;
            }
            if (this.file[n2 - 1] == '/') {
                --n2;
            }
            this.curAttributes = n2 - n3 > 0 ? new String(this.file, n3, n2 - n3) : "";
            ++this.pos;
            return n4;
        }
        if (n == 1) {
            int n6;
            int n7 = this.pos;
            while (true) {
                int n8;
                int n9;
                if ((n6 = this.getNextPosition('<', false, true)) == -1) {
                    return -1;
                }
                if ((n9 = ++this.pos) >= this.file.length - 1) {
                    return -1;
                }
                if (this.file[n9] != '/') continue;
                ++this.pos;
                if (this.getNextPosition(' ', false, false) == -1) continue;
                n9 = this.pos;
                while (this.pos < this.file.length && (Character.isLetterOrDigit(this.file[this.pos]) || this.file[this.pos] == '_') || this.file[this.pos] == ':') {
                    ++this.pos;
                }
                if (n9 != this.pos && this.curTagType.equalsIgnoreCase(new String(this.file, n9, (n8 = this.pos) - n9)) && this.getNextPosition(' ', false, false) != -1 && this.file[this.pos] == '>') break;
            }
            this.curBody = new char[n6 - n7];
            System.arraycopy(this.file, n7, this.curBody, 0, n6 - n7);
            ++this.pos;
            return this.pos - 1;
        }
        return -1;
    }

    private int getNextPosition(char c, boolean bl, boolean bl2) {
        int n = this.pos;
        while (this.pos < this.file.length && (bl2 && this.file[this.pos] != c || !bl2 && (bl && this.file[this.pos] == c || !bl && (this.file[this.pos] == c || this.file[this.pos] == '\r' || this.file[this.pos] == '\n'))) && (!bl || this.file[this.pos] != '\r' && this.file[this.pos] != '\n')) {
            ++this.pos;
        }
        if (this.pos == this.file.length || bl && (this.file[this.pos] == '\r' || this.file[this.pos] == '\n')) {
            return -1;
        }
        n = this.pos;
        return n;
    }

    private boolean isMatchedTag(int n, int n2) {
        String string = new String(this.file, n, n2 - n);
        for (int i = 0; i < this.tags.length; ++i) {
            if (!this.tags[i].equalsIgnoreCase(string)) continue;
            this.curTagType = string.toLowerCase();
            return true;
        }
        return false;
    }

    private char[] getChars(String string) {
        if (string == null) {
            return new char[0];
        }
        char[] cArray = new char[string.length()];
        string.getChars(0, string.length(), cArray, 0);
        return cArray;
    }

    public void parse() {
        this.pos = 0;
        this.elements = new Vector();
        int n = 0;
        while (this.pos < this.file.length) {
            Element element = new Element();
            int n2 = this.getNextPoint(0);
            if (n2 == -1) {
                if (this.file.length <= n) continue;
                element.type = "text";
                Element.access$302(element, new char[this.file.length - n]);
                System.arraycopy(this.file, n, element.body, 0, this.file.length - n);
                this.elements.add(element);
                n = this.file.length;
                continue;
            }
            if (n2 > n) {
                Element element2 = new Element();
                element2.type = "text";
                Element.access$302(element2, new char[n2 - n]);
                System.arraycopy(this.file, n, element2.body, 0, n2 - n);
                this.elements.add(element2);
            }
            boolean bl = true;
            try {
                for (int i = 0; i < this.tags.length; ++i) {
                    if (!this.tags[i].equalsIgnoreCase(this.curTagType)) continue;
                    bl = this.hasBodies[i];
                    break;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.file[this.pos - 2] == '/' || !bl) {
                element.type = this.curTagType;
                element.setAttributes(this.curAttributes);
                Element.access$302(element, null);
                this.elements.add(element);
                n = this.pos;
                continue;
            }
            int n3 = this.getNextPoint(1);
            if (n3 == -1) continue;
            element.type = this.curTagType;
            element.setAttributes(this.curAttributes);
            Element.access$302(element, this.curBody);
            this.elements.add(element);
            n = this.pos;
        }
    }

    public static String replace(String string, String string2, String string3) {
        try {
            StringBuffer stringBuffer = new StringBuffer(string.length());
            int n = 0;
            int n2 = 0;
            int n3 = string2.length();
            while ((n = string.indexOf(string2, n)) >= 0) {
                stringBuffer = stringBuffer.append(string.substring(n2, n)).append(string3);
                n2 = n += n3;
            }
            stringBuffer = stringBuffer.append(string.substring(n2));
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static char[] append(char[] cArray, char[] cArray2) {
        if (cArray == null) {
            return cArray2;
        }
        if (cArray2 == null) {
            return cArray;
        }
        char[] cArray3 = new char[cArray.length + cArray2.length];
        System.arraycopy(cArray, 0, cArray3, 0, cArray.length);
        System.arraycopy(cArray2, 0, cArray3, cArray.length, cArray2.length);
        return cArray3;
    }

    public static void main(String[] stringArray) {
    }

    public class Element {
        private String type;
        private Hashtable attributes = null;
        private char[] body = null;
        private Vector elements = null;

        public String getType() {
            return this.type;
        }

        public Element[] getChildren() {
            if (this.elements != null) {
                return this.elements.toArray(new Element[0]);
            }
            return new Element[0];
        }

        public char[] getBody() {
            return this.body;
        }

        public String getBodyAsString() {
            return new String(this.body);
        }

        public void setBody(char[] cArray) {
            this.body = cArray;
        }

        public void setBody(String string) {
            this.body = Parser.this.getChars(string);
        }

        public void setAttributes(String string) {
            this.attributes = this.parseAttributes(string);
        }

        public void setAttribute(String string, String string2) {
            this.attributes.put(string.toLowerCase(), string2);
        }

        public String getAttribute(String string) {
            try {
                return (String)this.attributes.get(string.toLowerCase());
            }
            catch (Exception exception) {
                return null;
            }
        }

        public Hashtable getAttributes() {
            return this.attributes;
        }

        public void parseBody(String[] stringArray, boolean[] blArray) {
            if (this.body != null && this.body.length > 0) {
                Parser parser = new Parser(this.body, stringArray, blArray);
                parser.parse();
                this.elements = parser.elements;
            }
        }

        public String getAsTag() {
            Object object;
            if (this.type.equalsIgnoreCase("text")) {
                if (this.body != null) {
                    return new String(this.body);
                }
                return null;
            }
            String string = "<" + this.type;
            if (this.attributes != null) {
                Enumeration enumeration = this.attributes.keys();
                while (enumeration.hasMoreElements()) {
                    object = (String)enumeration.nextElement();
                    string = string + " " + (String)object + "=\"" + (String)this.attributes.get(object) + "\"";
                }
            }
            if (this.body == null) {
                return string + "/>";
            }
            string = string + ">";
            if (this.elements == null) {
                return string + new String(this.body) + "</" + this.type + ">";
            }
            for (int i = 0; i < this.elements.size(); ++i) {
                object = (Element)this.elements.get(i);
                string = string + ((Element)object).getAsTag();
            }
            string = string + "</" + this.type + ">";
            return string;
        }

        public char[] getTag() {
            if (this.type.equalsIgnoreCase("text")) {
                if (this.body != null) {
                    return this.body;
                }
                return new char[0];
            }
            String string = this.getAsTag();
            if (string == null) {
                return null;
            }
            char[] cArray = new char[string.length()];
            string.getChars(0, string.length(), cArray, 0);
            return cArray;
        }

        private Hashtable parseAttributes(String string) {
            if (string == null || string.length() == 0) {
                return null;
            }
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            Parser.replace(string, "\n", " ");
            Parser.replace(string, "\r", " ");
            while (string.indexOf(" =") >= 0) {
                string = Parser.replace(string, " =", "=");
            }
            while (string.indexOf("= ") >= 0) {
                string = Parser.replace(string, "= ", "=");
            }
            while (string.indexOf("  ") >= 0) {
                string = Parser.replace(string, "  ", " ");
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                StringTokenizer stringTokenizer2 = new StringTokenizer(string2, "=");
                String string3 = null;
                String string4 = "";
                try {
                    string3 = stringTokenizer2.nextToken();
                    string4 = stringTokenizer2.nextToken();
                    if (string4.indexOf("\"") == 0 && string4.lastIndexOf("\"") == string4.length() - 1 || string4.indexOf("'") == 0 && string4.lastIndexOf("'") == string4.length() - 1) {
                        string4 = string4.substring(1, string4.length() - 1);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (string3 == null) continue;
                hashtable.put(string3.toLowerCase(), string4);
            }
            if (hashtable.size() > 0) {
                return hashtable;
            }
            return null;
        }

        static /* synthetic */ char[] access$302(Element element, char[] cArray) {
            element.body = cArray;
            return cArray;
        }
    }
}

