/*
 * Decompiled with CFR 0.152.
 */
package org.webjinn.cms.model.xml;

import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.webjinn.cms.model.Attribute;
import org.webjinn.cms.model.CMSTree;
import org.webjinn.cms.model.CSSFile;
import org.webjinn.cms.model.InterfaceTreeElement;
import org.webjinn.cms.model.Item;
import org.webjinn.cms.model.Menu;
import org.webjinn.cms.model.xml.Utils;
import org.webjinn.cms.model.xml.XMLAttributeImpl;
import org.webjinn.cms.model.xml.XMLCMSTree;
import org.webjinn.cms.model.xml.XMLCSSFileImpl;
import org.webjinn.cms.model.xml.XMLItemImpl;

public class XMLMenuImpl
implements Menu {
    private Element el;
    private XMLCMSTree tree;
    private Node attributesNode;
    private Node cssfilesNode;

    public XMLMenuImpl(Element element, XMLCMSTree xMLCMSTree) {
        this.el = element;
        this.tree = xMLCMSTree;
        this.attributesNode = Utils.getChildNodeByName(element, "attributes");
        this.cssfilesNode = Utils.getChildNodeByName(element, "cssfiles");
    }

    public String getName() {
        return this.el.getAttribute("name");
    }

    public String getInterfaceURI() {
        StringBuffer stringBuffer = new StringBuffer();
        Node node = this.el;
        Node node2 = node.getParentNode();
        stringBuffer.append(this.el.getAttribute("name"));
        while (!node2.getNodeName().equals("interface")) {
            node = node.getParentNode().getParentNode();
            stringBuffer.insert(0, node.getAttribute("name") + "/");
            node2 = node.getParentNode();
        }
        stringBuffer.insert(0, ((Element)node2).getAttribute("name") + "/");
        return stringBuffer.toString();
    }

    public String getHeader() {
        Node node = this.getChildCDATA("header");
        if (node != null) {
            return node.getNodeValue();
        }
        return "";
    }

    public String getFooter() {
        Node node = this.getChildCDATA("footer");
        if (node != null) {
            return node.getNodeValue();
        }
        return "";
    }

    public void setHeader(String string) {
        Node node = this.getChildCDATA("header");
        node.setNodeValue(string);
        this.tree.updateFile();
    }

    public void setFooter(String string) {
        Node node = this.getChildCDATA("footer");
        node.setNodeValue(string);
        this.tree.updateFile();
    }

    public Item getParentItem() {
        Node node = this.el.getParentNode();
        if (node != null && node.getNodeName().equals("item")) {
            return new XMLItemImpl((Element)node, this.tree);
        }
        return null;
    }

    public Item[] getChildItems() {
        List list = Utils.getChildNodesByName(this.el, "item");
        int n = list.size();
        Item[] itemArray = new Item[n];
        for (int i = 0; i < n; ++i) {
            itemArray[i] = new XMLItemImpl((Element)list.get(i), this.tree);
        }
        return itemArray;
    }

    public Item getChildItem(String string) {
        List list = Utils.getChildNodesByName(this.el, "item");
        for (int i = 0; i < list.size(); ++i) {
            if (!((Element)list.get(i)).getAttribute("name").equals(string)) continue;
            return new XMLItemImpl((Element)list.get(i), this.tree);
        }
        return null;
    }

    public void addItem(String string) {
        if (string == null || string.length() == 0 || this.getChildItem(string) != null) {
            return;
        }
        Element element = XMLItemImpl.createItem(this.el.getOwnerDocument(), string);
        this.el.appendChild(element);
        this.tree.updateFile();
    }

    public void removeItem(Item item) {
        if (item instanceof XMLItemImpl) {
            this.tree.updatePagesOnRemove(item);
            Element element = ((XMLItemImpl)item).getXMLElement();
            this.el.removeChild(element);
            this.tree.updateFile();
        }
    }

    public InterfaceTreeElement getParent() {
        return this.getParentItem();
    }

    public String buildHeader() {
        return "";
    }

    public String buildFooter() {
        return "";
    }

    public CSSFile[] getCSSFiles() {
        List list = Utils.getChildNodesByName(this.cssfilesNode, "cssfile");
        int n = list.size();
        CSSFile[] cSSFileArray = new CSSFile[n];
        for (int i = 0; i < n; ++i) {
            cSSFileArray[i] = new XMLCSSFileImpl((Element)list.get(i), this);
        }
        return cSSFileArray;
    }

    public CSSFile getCSSFile(String string) {
        if (string == null) {
            return null;
        }
        List list = Utils.getChildNodesByName(this.cssfilesNode, "cssfile");
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            Element element = (Element)list.get(i);
            String string2 = element.getAttribute("url");
            if (string2 == null || !string2.equals(string)) continue;
            return new XMLCSSFileImpl(element, this);
        }
        return null;
    }

    public void addCSSFile(String string) {
        if (string == null || string.length() == 0) {
            return;
        }
        Element element = XMLCSSFileImpl.createCSSFile(this.el.getOwnerDocument(), string);
        this.cssfilesNode.appendChild(element);
        this.tree.updateFile();
    }

    public void removeCSSFile(CSSFile cSSFile) {
        if (cSSFile instanceof XMLCSSFileImpl) {
            Element element = ((XMLCSSFileImpl)cSSFile).getXMLElement();
            this.cssfilesNode.removeChild(element);
            this.tree.updateFile();
        }
    }

    public Attribute[] getAttributes() {
        List list = Utils.getChildNodesByName(this.attributesNode, "attribute");
        int n = list.size();
        Attribute[] attributeArray = new Attribute[n];
        for (int i = 0; i < n; ++i) {
            attributeArray[i] = new XMLAttributeImpl((Element)list.get(i), this);
        }
        return attributeArray;
    }

    public Attribute getAttribute(String string) {
        List list = Utils.getChildNodesByName(this.attributesNode, "attribute");
        for (int i = 0; i < list.size(); ++i) {
            if (!((Element)list.get(i)).getAttribute("name").equals(string)) continue;
            return new XMLAttributeImpl((Element)list.get(i), this);
        }
        return null;
    }

    public void addAttribute(String string, String string2, String string3) {
        if (string == null || string.length() == 0) {
            return;
        }
        Attribute attribute = this.getAttribute(string);
        if (attribute != null) {
            if (string2 == null) {
                string2 = "";
            }
            if (string3 == null) {
                string3 = "";
            }
            attribute.setDescription(string2);
            attribute.setValue(string3);
        } else {
            Element element = XMLAttributeImpl.createAttribute(this.el.getOwnerDocument(), string, string2, string3);
            this.attributesNode.appendChild(element);
        }
        this.tree.updateFile();
    }

    public void removeAttribute(Attribute attribute) {
        if (attribute instanceof XMLAttributeImpl) {
            Element element = ((XMLAttributeImpl)attribute).getXMLElement();
            this.attributesNode.removeChild(element);
            this.tree.updateFile();
        }
    }

    private Node getChildCDATA(String string) {
        try {
            Node node = Utils.getChildNodeByName(this.el, string);
            return Utils.getCDATAChild(node);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public CMSTree getCMSTree() {
        return this.tree;
    }

    protected Element getXMLElement() {
        return this.el;
    }

    protected static Element createMenu(Document document, String string) {
        Element element = Utils.createElementNode(document, "menu");
        element.setAttribute("name", string);
        Element element2 = Utils.createElementNode(document, "header");
        Element element3 = Utils.createElementNode(document, "footer");
        Element element4 = Utils.createElementNode(document, "attributes");
        Element element5 = Utils.createElementNode(document, "cssfiles");
        element.appendChild(element2);
        element.appendChild(element3);
        element.appendChild(element4);
        element.appendChild(element5);
        return element;
    }
}

