/*
 * Decompiled with CFR 0.152.
 */
package org.webjinn.cms.model.xml;

import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.webjinn.cms.model.Attribute;
import org.webjinn.cms.model.CMSTree;
import org.webjinn.cms.model.InterfaceTreeElement;
import org.webjinn.cms.model.Item;
import org.webjinn.cms.model.Menu;
import org.webjinn.cms.model.xml.Utils;
import org.webjinn.cms.model.xml.XMLAttributeImpl;
import org.webjinn.cms.model.xml.XMLCMSTree;
import org.webjinn.cms.model.xml.XMLMenuImpl;

public class XMLItemImpl
implements Item {
    private Element el;
    private Document doc;
    private XMLCMSTree tree;
    private Node attributesNode;

    public XMLItemImpl(Element element, XMLCMSTree xMLCMSTree) {
        this.el = element;
        this.doc = element.getOwnerDocument();
        this.tree = xMLCMSTree;
        this.attributesNode = Utils.getChildNodeByName(element, "attributes");
    }

    public String getName() {
        return this.el.getAttribute("name");
    }

    public String getInterfaceURI() {
        return this.getParentMenu().getInterfaceURI() + ":" + this.getName();
    }

    public Menu getParentMenu() {
        Node node = this.el.getParentNode();
        if (node != null && node.getNodeName().equals("menu")) {
            return new XMLMenuImpl((Element)node, this.tree);
        }
        return null;
    }

    public Menu getChildMenu() {
        Node node = Utils.getChildNodeByName(this.el, "menu");
        if (node != null) {
            return new XMLMenuImpl((Element)node, this.tree);
        }
        return null;
    }

    public void associate(String string) {
        if (string == null || string.length() == 0) {
            return;
        }
        Node node = Utils.getChildNodeByName(this.el, "menu");
        if (node != null) {
            return;
        }
        Element element = XMLMenuImpl.createMenu(this.el.getOwnerDocument(), string);
        this.el.appendChild(element);
        this.tree.updateFile();
    }

    public void disassociate() {
        Node node = Utils.getChildNodeByName(this.el, "menu");
        if (node == null) {
            return;
        }
        this.tree.updatePagesOnRemove(this.getChildMenu());
        this.el.removeChild(node);
        this.tree.updateFile();
    }

    public void moveItem(boolean bl) {
        Node node = null;
        Node node2 = null;
        if (bl) {
            node = this.el.getPreviousSibling();
            node2 = this.el;
        } else {
            node = this.el;
            node2 = this.el.getNextSibling();
        }
        if (node == null || node2 == null) {
            return;
        }
        Node node3 = this.el.getParentNode();
        node3.removeChild(node2);
        node3.insertBefore(node2, node);
        this.tree.updateFile();
    }

    public InterfaceTreeElement getParent() {
        return this.getParentMenu();
    }

    public String buildHeader() {
        return "";
    }

    public String buildFooter() {
        return "";
    }

    public Attribute[] getAttributes() {
        List list = Utils.getChildNodesByName(this.attributesNode, "attribute");
        int n = list.size();
        Attribute[] attributeArray = new Attribute[n];
        for (int i = 0; i < n; ++i) {
            attributeArray[i] = new XMLAttributeImpl((Element)list.get(i), this);
        }
        return attributeArray;
    }

    public Attribute getAttribute(String string) {
        List list = Utils.getChildNodesByName(this.attributesNode, "attribute");
        for (int i = 0; i < list.size(); ++i) {
            if (!((Element)list.get(i)).getAttribute("name").equals(string)) continue;
            return new XMLAttributeImpl((Element)list.get(i), this);
        }
        return null;
    }

    public void addAttribute(String string, String string2, String string3) {
        if (string == null || string.length() == 0) {
            return;
        }
        Attribute attribute = this.getAttribute(string);
        if (attribute != null) {
            if (string2 == null) {
                string2 = "";
            }
            if (string3 == null) {
                string3 = "";
            }
            attribute.setDescription(string2);
            attribute.setValue(string3);
        } else {
            Element element = XMLAttributeImpl.createAttribute(this.doc, string, string2, string3);
            this.attributesNode.appendChild(element);
        }
        this.tree.updateFile();
    }

    public void removeAttribute(Attribute attribute) {
        if (attribute instanceof XMLAttributeImpl) {
            Element element = ((XMLAttributeImpl)attribute).getXMLElement();
            this.attributesNode.removeChild(element);
            this.tree.updateFile();
        }
    }

    public CMSTree getCMSTree() {
        return this.tree;
    }

    protected Element getXMLElement() {
        return this.el;
    }

    protected static Element createItem(Document document, String string) {
        Element element = Utils.createElementNode(document, "item");
        element.setAttribute("name", string);
        Element element2 = Utils.createElementNode(document, "attributes");
        element.appendChild(element2);
        return element;
    }
}

