/*
 * Decompiled with CFR 0.152.
 */
package org.webjinn.cms.model.xml;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.webjinn.cms.model.Attribute;
import org.webjinn.cms.model.CMSTreeNode;
import org.webjinn.cms.model.xml.Utils;

public class XMLAttributeImpl
implements Attribute {
    private Element el;
    private CMSTreeNode host;

    public XMLAttributeImpl(Element element, CMSTreeNode cMSTreeNode) {
        this.el = element;
        this.host = cMSTreeNode;
    }

    public CMSTreeNode getHost() {
        return this.host;
    }

    public String getName() {
        return this.el.getAttribute("name");
    }

    public String getValue() {
        Node node = Utils.getCDATAChild(this.el);
        return node.getNodeValue();
    }

    public String getDescription() {
        return this.el.getAttribute("description");
    }

    public void setDescription(String string) {
        this.el.setAttribute("description", string);
        Utils.update(this.host.getCMSTree());
    }

    public void setValue(String string) {
        try {
            Node node = Utils.getCDATAChild(this.el);
            node.setNodeValue(string);
            Utils.update(this.host.getCMSTree());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected Element getXMLElement() {
        return this.el;
    }

    protected static Element createAttribute(Document document, String string, String string2, String string3) {
        Element element = Utils.createElementNode(document, "attribute");
        element.setAttribute("name", string);
        if (string2 != null) {
            element.setAttribute("description", string2);
        }
        if (string3 != null) {
            Node node = Utils.getCDATAChild(element);
            node.setNodeValue(string3);
        }
        return element;
    }
}

