/*
 * Decompiled with CFR 0.152.
 */
package org.webjinn.cms.model.xml;

import java.util.List;
import java.util.Vector;
import org.apache.xerces.dom.CDATASectionImpl;
import org.apache.xerces.dom.CoreDocumentImpl;
import org.apache.xerces.dom.ElementImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.webjinn.cms.model.CMSTree;
import org.webjinn.cms.model.xml.XMLCMSTree;

public class Utils {
    public static String getAttributeValue(Node node, String string) {
        if (node == null || string == null) {
            return null;
        }
        NamedNodeMap namedNodeMap = node.getAttributes();
        Node node2 = namedNodeMap.getNamedItem(string);
        if (node2 != null) {
            return node2.getNodeValue();
        }
        return null;
    }

    public static Node getChildNodeByName(Node node, String string) {
        NodeList nodeList = node.getChildNodes();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Node node2 = nodeList.item(i);
            if (!node2.getNodeName().equals(string)) continue;
            return node2;
        }
        return null;
    }

    public static List getChildNodesByName(Node node, String string) {
        NodeList nodeList = node.getChildNodes();
        Vector<Node> vector = new Vector<Node>();
        try {
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                Node node2 = nodeList.item(i);
                if (!node2.getNodeName().equals(string)) continue;
                vector.add(node2);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return vector;
    }

    public static NodeList getAttributeNodes(Node node) {
        Node node2 = Utils.getChildNodeByName(node, "attributes");
        if (node2 != null && node2 instanceof Element) {
            return ((Element)node2).getElementsByTagName("attribute");
        }
        return null;
    }

    public static NodeList getCSSFileNodes(Node node) {
        Node node2 = Utils.getChildNodeByName(node, "cssfiles");
        if (node2 != null && node2 instanceof Element) {
            return ((Element)node2).getElementsByTagName("cssfile");
        }
        return null;
    }

    public static Node getCDATAChild(Node node) {
        Node node2 = Utils.getChildNodeByName(node, "#cdata-section");
        if (node2 == null) {
            node2 = Utils.createCDATANode(node.getOwnerDocument(), "");
            node.appendChild(node2);
        }
        return node2;
    }

    public static Node createCDATANode(Document document, String string) {
        if (document instanceof CoreDocumentImpl) {
            CoreDocumentImpl coreDocumentImpl = (CoreDocumentImpl)document;
            CDATASectionImpl cDATASectionImpl = new CDATASectionImpl(coreDocumentImpl, string);
            return cDATASectionImpl;
        }
        return null;
    }

    public static Element createElementNode(Document document, String string) {
        if (document instanceof CoreDocumentImpl) {
            CoreDocumentImpl coreDocumentImpl = (CoreDocumentImpl)document;
            ElementImpl elementImpl = new ElementImpl(coreDocumentImpl, string);
            return elementImpl;
        }
        return null;
    }

    public static void update(CMSTree cMSTree) {
        if (cMSTree instanceof XMLCMSTree) {
            ((XMLCMSTree)cMSTree).updateFile();
        }
    }
}

