package pwbuilder.integration;
import java.io.FileInputStream;
import java.io.File;
import java.util.Properties;

/** Introduces PWBuilder properties as system properties */ 
public aspect IntegrateProperties {
  static final String PROP_FILE="pwbuilder.properties";
  static boolean initialized=false;

  before(): execution(public static void sun.beanbox.BeanBoxFrame.main(String[])) {
    if (!initialized) {
      FileInputStream propFileStream=null;
      File propFile = new File(PROP_FILE);
      try{
        //System.out.println("Loading PWBuilder properties from "+propFile.getAbsolutePath());
        propFileStream = new FileInputStream(propFile);
        Properties p = new Properties(System.getProperties());
        p.load(propFileStream);
        System.setProperties(p);
        initialized=true;
      } catch (Exception e) {
        System.err.println("PWBuilder properties file "+propFile.getAbsolutePath()+" cannot be opened!");
        e.printStackTrace();
        System.err.println("exiting...");
        System.exit(-1);
      }
      finally {
        try{propFileStream.close();}catch (Exception e) {}
      }
    }
  }
}
