package pwbuilder.core;
import java.lang.reflect.Method;
import java.io.*;

/** JavaBeans implementation of the receiver method descriptors interface MethodDescr.
  * @author Sergei Kojarski */
public class MethodDescrImpl implements MethodDescr, Serializable {
  private transient Method method;
  private String mName;

  /** @@see pwbuilder.core.MethodDescr */
  public String getName() {
    if (method!=null) return method.getName();
    return null;
  }

  /** @@see pwbuilder.core.MethodDescr */
  public Method getMethod() {
    return method;
  }

  /** Sets java.lang.reflect.Method method representation */
  public void setMethod(Method method) {
    this.method=method;
    if (method!=null) this.mName=method.getName();
  }

  private synchronized void writeObject(ObjectOutputStream outStream)
    throws IOException {
      outStream.defaultWriteObject();
    }

  private synchronized void readObject(ObjectInputStream inStream)
    throws ClassNotFoundException, IOException {
      inStream.defaultReadObject();
      method=null;
    }

}
