package peterson;
import java.awt.event.*;
import java.awt.*;
import java.util.*;
import java.io.*;
import pwbuilder.core.*;

public class TextWriter extends Panel
	implements ActionListener, TRMListener, 
			   Serializable, StateMachineAvailable, Runnable {

  private static final String SAMPLE_MSG = "Sample Message";
  private static final int MESSAGE_FIELD_SIZE = 20;
  private static final int NUMBER_OF_REQUESTS = 4;  

  private TextField messageField_ = new TextField(SAMPLE_MSG, MESSAGE_FIELD_SIZE);
  private transient Thread t = null;
  private StateMachine stateMachine_ = null;

  /** TRM */
  private TWListener manager = null;
  /** TR */
  private TextUpdateListener resource = null;


  public TextWriter() {
    add(messageField_);
    //to be removed
    instancesNum++;
    thisInstanceNum = instancesNum;
    //to be removed
  }

  /** To be removed */
  public String toString() {return "TW"+thisInstanceNum;}
  private static int instancesNum = 0;
  private int thisInstanceNum;
  /** To be removed */ 


  /** Event is received when the component is granted access to the CS */
  public synchronized void receiveTRMEvent(TRMEvent event) {
    notifyAll();
  } 

  /** Sends the request event to the manager, and waits for the access to be granted. 
      When access to the CS is granted, sends a message to the resource (TR), and
      sends release event to the manager.
      The component should be connected to both TR and TRM in order for 
      the thread to function. Otherwise the thread simply dies.  */
  public void run() {
    if (manager==null || resource==null) return;
    System.out.println(this+": STARTED");
    int reqs = 0;
    while(reqs<NUMBER_OF_REQUESTS) {
      reqs++;
      synchronized(this) {
        manager.receiveTWEvent(new TWEvent(this,true));
        try {wait();} catch (InterruptedException e) {}
      }
      System.out.println(this+" is granted access to the CS");
      fireTextUpdateEvent();
      manager.receiveTWEvent(new TWEvent(this,false));
    }
    System.out.println(this+": STOPPED!");
  }

  private void fireTextUpdateEvent() {
    //System.out.println(this+": fireTextUpdate="+messageField_.getText());
    String message = messageField_.getText();
    int len = message.length();
    for (int i=0;i<=len;i++) {
      String ch="\n";
      if (i<len) ch = String.valueOf(message.charAt(i));
      TextUpdateEvent ev = new TextUpdateEvent(this,ch);
      resource.receiveTextUpdateEvent(ev);
      try{Thread.currentThread().sleep(100);} catch (Exception e) {}
    } 
  }
 
  /** Activates the component's thread. 
      If the thread is already activated, then has no effect */
  public synchronized void actionPerformed(ActionEvent e) {	
    if (t==null || !t.isAlive()) {
      try{
        t = new Thread(this);
        t.start();  
      } catch (Exception exc) {exc.printStackTrace();}
    }
  }
    
  public StateMachine getStateMachine(SystemDescr system) {
	  return new TWStateMachine(system,this);
  }
  
  private void writeObject(ObjectOutputStream outStream)
    throws IOException {
      outStream.defaultWriteObject();
    }

  private synchronized void readObject(ObjectInputStream inStream)
    throws ClassNotFoundException, IOException {
      //deserialize all non transient objects first
      inStream.defaultReadObject();
    }

////////////////// Assembly-time functionality

  public void addTWListener(TWListener manager) {this.manager=manager;}
  public void removeTWListener(TWListener manager) {
    if (this.manager==manager) this.manager=null;
  }

  //this container holds things that can receive TextUpdateEvents, 
  //for instance, a TextResource component...
  public void addTextUpdateListener(TextUpdateListener listener) {
    this.resource = listener;
  }
  public void removeTextUpdateListener(TextUpdateListener listener) {
    if (resource == listener) resource=null;
  }
}
