package pwbuilder.integration;
import pwbuilder.core.*;
import java.beans.*;
import java.lang.reflect.Method;
import java.util.Hashtable;

public aspect IntegrateSystemDescr {
//  private int next_id=0;
//  private Hashtable components= new Hashtable();
  private SystemDescrImpl systemDescr = new SystemDescrImpl();

  after(EventSetDescriptor esd, Method lm, Object s, Object t, Method tm) 
    returning(Object result): 
    execution(static String sun.beanbox.HookupManager.generateHookup(EventSetDescriptor,Method,Object,Object,Method)) && args(esd,lm,s,t,tm) {
      synchronized(this) {
        ConnectionDescrImpl conn = new ConnectionDescrImpl();
        ComponentDescr t_comp = systemDescr.getComponent(t);
                              //(ComponentDescr)components.get(t);
        ComponentDescr s_comp = systemDescr.getComponent(s); 
                              //(ComponentDescr)components.get(s);
        conn.setTargetComponent(t_comp);
        conn.setSourceComponent(s_comp);
        MethodDescrImpl t_meth = new MethodDescrImpl();
        t_meth.setMethod(tm);
        conn.setTargetMethod(t_meth);
        conn.setEventSetDescr(esd);
        systemDescr.addConnection(conn);
      }
      //  System.out.println("comp_t:"+t+", meth_t="+tm.getName()+", comp_s="+s+", event_t="+esd.getName()+", lm="+lm.getName()); 
      System.out.println("getName="+esd.getName()+", displayName="+esd.getDisplayName()+", descr="+esd.getShortDescription());
    }

  after(Object bean) returning(Object result): 
    execution(void sun.beanbox.BeanBox.doInsert(..)) && args(bean,..) {
      synchronized(this) {
        ComponentDescrImpl component = new ComponentDescrImpl();
        int next_id = systemDescr.getComponentsCount();
        component.setId(next_id);
        component.setComponentObject(bean);
        //next_id=next_id+1; 
        /*
        if (bean instanceof StateMachineAvailable) {
          StateMachine sm = ((StateMachineAvailable)bean).getStateMachine();
          component.setStateMachine(sm);
        }*/
        //components.put(bean,component);
        systemDescr.addComponent(component); 
      }
    }

  after(java.io.ObjectInputStream ois) returning(Object result): 
    execution(private void sun.beanbox.BeanBox.readContents(java.io.ObjectInputStream)) && args(ois) {
      System.out.println(thisJoinPoint);
      try{
      Object system = ois.readObject();
      if (system instanceof SystemDescrImpl) {
        this.systemDescr = (SystemDescrImpl)system;
      } else {
        System.err.println("Cannot load component system description!");
      }
      } catch (Exception e) {
        e.printStackTrace();
      }
    }


  after(java.io.ObjectOutputStream s) returning(Object result): 
    execution(private void sun.beanbox.BeanBox.writeContents(java.io.ObjectOutputStream)) && args(s) {
      System.out.println(thisJoinPoint);
      try{
        s.writeObject(systemDescr);
      } catch (Exception e) {
        e.printStackTrace();
      }
    }

  
  public static SystemDescr getSystemDescr() {
    return IntegrateSystemDescr.aspectOf().systemDescr;
  }
}
