package pwbuilder.core;
import java.util.Vector;
import java.io.*;

/** Implementation of the SystemDescr interface.
  * @author Sergei Kojarski */
public class SystemDescrImpl implements SystemDescr, Serializable {
  private Vector components = new Vector();
  private Vector connections = new Vector();

  /** @@see pwbuilder.core.SystemDescr */
  public ComponentDescr[] getComponents() {
    return (ComponentDescr[])components.toArray(new ComponentDescr[0]);
  }

  /** @@see pwbuilder.core.SystemDescr */
  public ComponentDescr getComponent(Object compObj) {
    ComponentDescr[] cmps = getComponents();
    for (int i=0;i<cmps.length;i++) 
      if (cmps[i].getComponentObject()==compObj) return cmps[i];
    return null;
  }

  /** Extends the system description with a component description. */
  public void addComponent(ComponentDescr cd) {
    System.out.println("New component is added:"+cd);
    components.add(cd);
  }

  /** @@see pwbuilder.core.SystemDescr */
  public ConnectionDescr[] getConnections() {
    return (ConnectionDescr[])connections.toArray(new ConnectionDescr[0]);
  }

  /** Extends the system description with a connection description. */
  public void addConnection(ConnectionDescr cd) {
    System.out.println("New connection is added:"+cd);
    connections.add(cd);
  }

  /** Auxiliary method for internal use */
  public int getComponentsCount() {
    return components.size();
  }

  private synchronized void writeObject(ObjectOutputStream outStream)
    throws IOException {
      outStream.defaultWriteObject();
    }

  private synchronized void readObject(ObjectInputStream inStream)
    throws ClassNotFoundException, IOException {
      inStream.defaultReadObject();
    }

}
