package peterson;
import java.lang.reflect.*;
import java.awt.*;
import java.beans.*;

/**
 * provides bean info information for the TextWriter class
 * 
 * @author      Brian Knolhoff
 */
public class TextWriterBeanInfo extends SimpleBeanInfo {
  private static final Class BEAN_CLASS = TextWriter.class;
  private static final Class TEXT_UPDATE_LISTENER_CLASS = TextUpdateListener.class;
  private static final Class TW_LISTENER_CLASS = TWListener.class;

  /**
   * Provides event set descriptors so that clients can register for
   * change events based on the specific value (output or
   * carryOut) they want to get updates for.
   *
   * @return      Array containing event entries for each of the two types
   *              of possible updates.
   */
  public EventSetDescriptor[] getEventSetDescriptors() {
    try {
      //create an event descriptor so that the listeners
      //can register for events
      EventSetDescriptor textUpdateEvent = new EventSetDescriptor(
          BEAN_CLASS,
          "textUpdate",
          TEXT_UPDATE_LISTENER_CLASS,
          "receiveTextUpdateEvent");

      EventSetDescriptor twEvent = new EventSetDescriptor(
          BEAN_CLASS,
          "tW",
          TW_LISTENER_CLASS,
          "receiveTWEvent");

      return new EventSetDescriptor[] { textUpdateEvent, twEvent};
    }
    catch(IntrospectionException e)
    {
      throw new Error(e.toString());
    }
  } 

  /*
  public PropertyDescriptor[] getPropertyDescriptors() {
    try {
      PropertyDescriptor manager = new PropertyDescriptor("manager",BEAN_CLASS);
      PropertyDescriptor resource = new PropertyDescriptor("resource",BEAN_CLASS);
      return new PropertyDescriptor[] { manager, resource };
    }
    catch(IntrospectionException e)
    {
      throw new Error(e.toString());
    }
  } */
}
