package peterson;
import java.awt.event.*;
import java.awt.*;
import java.util.*;
import java.io.*;
import pwbuilder.core.*;


public class TextWriter extends Panel
	implements ActionListener, TRMListener, 
			   Serializable, StateMachineAvailable, Runnable {

  private static final String SAMPLE_MSG = "Sample Message";
  private static final int INITIAL_INTERVAL = 1500;		//in milliseconds
  private static final int TEXT_UPDATE_LENGTH = 1000;   //in milliseconds
  private static final int MESSAGE_FIELD_SIZE = 20;
  private static final int INTERVAL_FIELD_SIZE = 5;

  
  //This takes care of the manager 
  private TWListener manager = null;
  public void addTWListener(TWListener manager) {this.manager=manager;}
  public void removeTWListener(TWListener manager) {
    if (this.manager==manager) this.manager=null;
  }

//  public void setManager(TWListener manager) {this.manager=manager;}
//  public TWListener getManager() {return this.manager;}

  //this container holds things that can receive TextUpdateEvents, 
  //for instance, a TextResource component...
  private TextUpdateListener resource = null;
  public void addTextUpdateListener(TextUpdateListener listener) {
    this.resource = listener;
  }
  public void removeTextUpdateListener(TextUpdateListener listener) {
    if (resource == listener) resource=null;
  }
//  public void setResource(TextUpdateListener resource) {this.resource=resource;}
//  public TextUpdateListener getResource() {return this.resource;}
  
  private boolean accessGranted = false;

  /** Implements TRMListener interface */
  public synchronized void receiveTRMEvent(TRMEvent event) {
    System.out.println(this+":"+"TRMEvent received="+event);
    if (event instanceof GrantEvent) {accessGranted=true; notifyAll();}
    if (event instanceof RejectEvent) {accessGranted=false; notifyAll();}
  } 

  private TextField messageField_ = new TextField(SAMPLE_MSG, MESSAGE_FIELD_SIZE);

  //default value of time between checks to send message is
  //1.5 seconds.  (1500ms)
  private int interval_ = INITIAL_INTERVAL;
  private TextField intervalField_ = new TextField(String.valueOf(interval_), INTERVAL_FIELD_SIZE);
  
  private transient Thread t = null;
  private StateMachine stateMachine_ = new StateMachine("***put Promela here***");  
  private boolean stop=true;

  /**
    * Default constructor initializes member variables, registers
    * this object to listen to the approriate events from member 
    * components, and starts the thread.  */
  public TextWriter() {
    add(messageField_);  	
    add(intervalField_);
  }
  
  /**
   * If the toggle button has been set to the on position,
   * then this method will continuously attempt to send 
   * messages to the registered TextUpdateListeners.
   * If available, access to the TextUpdateListener will
   * be synchronized by the use of a TextResourceManager  */
  public void run() {
    while(!stop) {
      System.out.println(this+":"+"stop="+stop+", manager="+manager+", resource="+resource);
      synchronized(this) {
        if (manager==null || resource==null) return;
        manager.receiveTWEvent(new RequestEvent(this));
        try {wait();} catch (InterruptedException e) {}
        System.out.println(this+": accessGranted="+accessGranted);
        if (accessGranted) {
          fireTextUpdateEvent();
          manager.receiveTWEvent(new ReleaseEvent(this));
        }
      } 
    }
  }

  private void fireTextUpdateEvent() {
    System.out.println(this+": fireTextUpdate="+messageField_.getText());
    if (resource!=null) 
      resource.receiveTextUpdateEvent(
          new TextUpdateEvent(this,messageField_.getText() + "\n"));
  }
  
  /** when theButton_ is clicked, toggle between sending 
   *  TextUpdateEvents and not sending TextUpdateEvents.  */
  public synchronized void actionPerformed(ActionEvent e) {	
    stop=!stop; 		
    if (!stop) {
      try{
        t = new Thread(this);
        t.start();  
        System.out.println("Starting TW "+this+" thread");
      } catch (Exception exc) {exc.printStackTrace();}
    } else {notifyAll();}
  }
    
  public StateMachine getStateMachine() {
	  return stateMachine_;
  }
  
  private void writeObject(ObjectOutputStream outStream)
    throws IOException {
      outStream.defaultWriteObject();
    }

  private synchronized void readObject(ObjectInputStream inStream)
    throws ClassNotFoundException, IOException {
      //deserialize all non transient objects first
      inStream.defaultReadObject();
    }
}
