package peterson;
import java.util.*;
import java.io.*;
import pwbuilder.core.*;

public class TWStateMachine implements StateMachine {
    //Component system
    private SystemDescr system;
    //Component object
    private TextWriter tw;
    //Identificator of the component that is described by this state machine 
    private int cid;
    private int trmCid;
    private int trCid;
    /** Variables that represent promela's global fields */
    private  String notifyName;

	public TWStateMachine(SystemDescr system, TextWriter tw) {
      this.system=system;
      this.tw=tw; 
      ComponentDescr twCD = system.getComponent(tw);
      this.cid = twCD.getId();
      notifyName = "notify_"+cid;

      trmCid=-1;
      trCid=-1;
      ConnectionDescr[] cons = system.getConnections();
      for (int i=0;i<cons.length;i++) {
        ComponentDescr srcCD = cons[i].getSourceComponent();
        ComponentDescr tgtCD = cons[i].getTargetComponent();
        if (srcCD.getId()==this.cid) {
          if (tgtCD.getComponentObject() instanceof TextResourceManager) 
            trmCid = tgtCD.getId(); 
          if (tgtCD.getComponentObject() instanceof TextResource) 
            trCid = tgtCD.getId(); 
          if (trCid>=0 && trmCid>=0) break;
        }
      }
    }

    /** @@see pwbuilder.core.StateMachine */
    public String generateGlobalVars() {
      String fields =
        "\n /** Global Declarations of the TextWriter"+cid+" component */ \n"+ 
        "bool "+notifyName+" = false; ";
      String inlineReceiveTRMEvent = 
        "inline receiveTRMEvent_"+cid+"(ev) {atomic{"+notifyName+"=true;}}";

      return fields + "\n\n" + inlineReceiveTRMEvent+"\n";
    }

    /** @@see pwbuilder.core.StateMachine */
    public String generateProcTypeDecls() {
      String result=
       "\n /** ProcType Declarations of the TextWriter"+cid+" component */ \n"+ 
      "active proctype run_"+cid+"() {\n"+
      "  TWEvent requestEvent,releaseEvent;\n"+
      "  requestEvent.source="+cid+";\n"+
      "  requestEvent.isRequest = true;\n"+
      "  releaseEvent.source="+cid+";\n"+
      "  releaseEvent.isRequest = false;\n"+
      "  TextUpdateEvent textEvent;\n"+
      "  textEvent.source="+cid+";\n"+
      "\n"+
      "  LOOP:\n";

      if (trmCid==-1) result=result+"  assert(0);\n";
      else result=result+ "  receiveTWEvent_"+trmCid+"(requestEvent);\n";

      result=result+
      "  atomic {("+notifyName+"==true) -> "+notifyName+"=false;}\n";

      if (trCid==-1) result=result+"  assert(0);\n"; 
      else result=result+"  receiveTextUpdateEvent_"+trCid+"(textEvent);\n";

      if (trmCid==-1) result=result+"  assert(0);\n";
      else result=result+ "  receiveTWEvent_"+trmCid+"(releaseEvent);\n";
      
      result=result+ 
      "  goto LOOP\n"+
      "} \n"; 
      return result;
    }

	private synchronized void writeObject(ObjectOutputStream outStream)
	  throws IOException {
		outStream.defaultWriteObject();
	}
	
    private synchronized void readObject(ObjectInputStream inStream)
	  throws ClassNotFoundException, IOException {
		inStream.defaultReadObject();
    }
}
