package peterson;
import java.util.*;
import java.io.*;
import pwbuilder.core.*;

/** */
public class TRStateMachine implements StateMachine {
    //Component system
    private SystemDescr system;
    //Component object
    private TextResource tr;
    private int cid;
    /** Variables that represent promela's global fields */
    private  String varName;

	public TRStateMachine(SystemDescr system, TextResource tr) {
      this.system=system;
      this.tr=tr; 
      ComponentDescr trCD = system.getComponent(tr);
      this.cid = trCD.getId();
      varName = "trflag_"+cid;
    }

    /** @@see pwbuilder.core.StateMachine */
    public String generateGlobalVars() {
      String fields =
        "\n /** Global Declarations of the TextResource"+cid+" component */ \n"+ 
        "bool "+varName+" = false; ";
      String inlineReceiveTextUpdateEvent = 
        " inline receiveTextUpdateEvent_"+cid+"(ev) {\n"+
        "  "+varName+" = !"+varName+";\n"+
        "  assert("+varName+");\n"+
        "  "+varName+" = !"+varName+";\n"+
        " }\n";

      return fields + "\n\n" + inlineReceiveTextUpdateEvent+"\n";
    }

    /** @@see pwbuilder.core.StateMachine */
    public String generateProcTypeDecls() {return "";}

	private synchronized void writeObject(ObjectOutputStream outStream)
	  throws IOException {
		outStream.defaultWriteObject();
	}
	
    private synchronized void readObject(ObjectInputStream inStream)
	  throws ClassNotFoundException, IOException {
		inStream.defaultReadObject();
    }
}
