package peterson;
import java.util.*;
import java.io.*;
import java.awt.*;
import pwbuilder.core.*;

/**
 * TextResource is a component derived from the TextArea component that is 
 * designed to accept TextUpdateEvent inputs from other components.
 *  
 * @author      Brian Knolhoff
 */
public class TextResource extends TextArea 
  implements TextUpdateListener, Serializable, StateMachineAvailable {

  private static final int NUM_ROWS = 10;
  private static final int NUM_COLS = 40;

  private StateMachine stateMachine_ = new StateMachine("***put Promela here***");

  /** get the state machine for this object */
  public StateMachine getStateMachine() {
    return stateMachine_;
  }

  /** Default constructor initializes member variables */
  public TextResource() {
    super(NUM_ROWS, NUM_COLS);	
    setEditable(false);
  }

  /** Every time the TextResource receives a TextUpdateEvent,
   *  it appends the text value from the update into the
   *  display window.  */
  public void receiveTextUpdateEvent(TextUpdateEvent param) {
    append(param.getValue());
  }

  private synchronized void writeObject(ObjectOutputStream outStream)
    throws IOException {
      outStream.defaultWriteObject();
    }

  private synchronized void readObject(ObjectInputStream inStream)
    throws ClassNotFoundException, IOException {
      inStream.defaultReadObject();
    }
}
