/*
 * Decompiled with CFR 0.152.
 */
package peterson;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Vector;
import peterson.TextResourceManager;
import pwbuilder.core.ComponentDescr;
import pwbuilder.core.ConnectionDescr;
import pwbuilder.core.StateMachine;
import pwbuilder.core.SystemDescr;

public class TRMStateMachine
implements StateMachine {
    private SystemDescr system;
    private TextResourceManager trm;
    private int cid;
    private String arrTypeName;
    private String rowsName;
    private String colsName;
    private String CName;
    private String TName;
    private String NName;
    private int[] twCids;

    public TRMStateMachine(SystemDescr systemDescr, TextResourceManager textResourceManager) {
        this.system = systemDescr;
        this.trm = textResourceManager;
        ComponentDescr componentDescr = systemDescr.getComponent((Object)textResourceManager);
        this.cid = componentDescr.getId();
        ConnectionDescr[] connectionDescrArray = systemDescr.getConnections();
        Vector<ConnectionDescr> vector = new Vector<ConnectionDescr>();
        int n = 0;
        while (n < connectionDescrArray.length) {
            if (connectionDescrArray[n].getSourceComponent().getId() == this.cid) {
                vector.add(connectionDescrArray[n]);
            }
            ++n;
        }
        int n2 = vector.size();
        this.twCids = new int[n2];
        int n3 = 0;
        while (n3 < n2) {
            ConnectionDescr connectionDescr = (ConnectionDescr)vector.get(n3);
            this.twCids[n3] = connectionDescr.getTargetComponent().getId();
            ++n3;
        }
        this.initVars();
    }

    private void initVars() {
        this.arrTypeName = "Array_" + this.cid;
        this.rowsName = "row_" + this.cid;
        this.colsName = "column_" + this.cid;
        this.CName = "C_" + this.cid;
        this.TName = "T_" + this.cid;
        this.NName = "N_" + this.cid;
    }

    public String generateGlobalVars() {
        int n = this.twCids.length;
        String string = "[" + n + "]";
        String string2 = "\n /** Global Declarations of the TextResourceManager_" + this.cid + " component */ \n" + "typedef " + this.arrTypeName + "{ bool " + this.rowsName + string + " = true};\n" + this.arrTypeName + " " + this.colsName + string + ";\n" + "bool " + this.CName + string + " = false; " + "bool " + this.TName + string + " = false; " + "bool " + this.NName + string + " = true; \n";
        String string3 = " inline TWEventAction_" + this.cid + "(pos, req) {\n" + "   if\n" + "     :: (req==true) ->\n" + "       atomic {\n" + "         assert(" + this.NName + "[pos] && !" + this.CName + "[pos] && !" + this.TName + "[pos]);\n" + "         " + this.NName + "[pos] = false; " + this.TName + "[pos] = true;\n" + "         byte ind=" + n + ";\n" + "         do\n" + "           :: (ind==0) -> break;\n" + "           :: else -> \n" + "             ind=ind-1;\n" + "             if\n" + "               :: (pos!=ind && " + this.TName + "[ind]) -> " + this.colsName + "[pos]." + this.rowsName + "[ind] = false;\n" + "               :: else -> skip;\n" + "             fi;\n" + "          od;\n" + "       }\n" + "     :: else -> atomic {\n" + "       assert(" + this.CName + "[pos] && !" + this.NName + "[pos] && !" + this.TName + "[pos]);\n" + "       " + this.CName + "[pos] = false; " + this.NName + "[pos] = true;\n" + "     }\n" + "   fi;\n" + " } \n";
        String string4 = " inline receiveTWEvent_" + this.cid + "(event) { \n" + this.generateCidToPosMapping() + "\n" + " }\n";
        return string2 + "\n\n" + string3 + "\n\n" + string4;
    }

    public String generateProcTypeDecls() {
        return "\n /** ProcType Declarations of the TextResourceManager_" + this.cid + " component */ \n" + this.generateRunProcTypeDecl();
    }

    private String generateRunProcTypeDecl() {
        int n = this.twCids.length;
        String string = "active proctype run_" + this.cid + "() {\n" + " TRMEvent event; event.source=" + this.cid + ";\n" + " byte twid=0;\n" + " LOOP: atomic { \n" + "   (";
        int n2 = 0;
        while (n2 < n) {
            if (n2 > 0) {
                string = string + " && ";
            }
            string = string + "!" + this.CName + "[" + n2 + "]";
            ++n2;
        }
        string = string + ") -> \n" + "    if \n";
        int n3 = 0;
        while (n3 < n) {
            string = string + "      :: " + this.generateGrantTest(n3) + " \n";
            ++n3;
        }
        string = string + "      ::else -> twid=0; \n" + "    fi;\n" + " } \n" + " if \n";
        int n4 = 0;
        while (n4 < n) {
            string = string + "   ::(twid==" + (this.twCids[n4] + 1) + ") -> receiveTRMEvent_" + this.twCids[n4] + "(event);\n";
            ++n4;
        }
        string = string + "   :: else -> skip; \n" + " fi; \n" + " goto LOOP \n" + "}";
        return string;
    }

    private String generateGrantTest(int n) {
        int n2 = this.twCids.length;
        String string = "(" + this.TName + "[" + n + "]";
        int n3 = 0;
        while (n3 < n2) {
            if (n3 != n) {
                string = string + " && (" + this.NName + "[" + n3 + "] || " + this.colsName + "[" + n + "]." + this.rowsName + "[" + n3 + "])";
            }
            ++n3;
        }
        string = string + ") -> " + this.TName + "[" + n + "]=false;" + this.CName + "[" + n + "]=true;";
        int n4 = 0;
        while (n4 < n2) {
            if (n4 != n) {
                string = string + this.colsName + "[" + n4 + "]." + this.rowsName + "[" + n + "]=true;";
            }
            ++n4;
        }
        string = string + "\n      twid=" + (this.twCids[n] + 1) + ";";
        return string;
    }

    private String generateCidToPosMapping() {
        int n = this.twCids.length;
        String string = "  if \n";
        int n2 = 0;
        while (n2 < n) {
            string = string + "    :: (event.source==" + this.twCids[n2] + ") -> TWEventAction_" + this.cid + "(" + n2 + ",event.isRequest);\n";
            ++n2;
        }
        return string + "    :: else -> assert(0); \n  fi;";
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
    }

    private synchronized void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
    }
}

