/*
 * Decompiled with CFR 0.152.
 */
package sunw.demo.molecule;

import java.awt.Graphics;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StreamTokenizer;
import java.util.Hashtable;
import sunw.demo.molecule.Atom;
import sunw.demo.molecule.Matrix3D;

class XYZChemModel {
    float[] vert;
    Atom[] atoms;
    int[] tvert;
    int[] ZsortMap;
    int nvert;
    int maxvert;
    static Hashtable atomTable = new Hashtable();
    static Atom defaultAtom;
    boolean transformed;
    Matrix3D mat = new Matrix3D();
    float xmin;
    float xmax;
    float ymin;
    float ymax;
    float zmin;
    float zmax;

    static {
        atomTable.put("c", new Atom(0, 0, 0));
        atomTable.put("h", new Atom(210, 210, 210));
        atomTable.put("n", new Atom(0, 0, 255));
        atomTable.put("o", new Atom(255, 0, 0));
        atomTable.put("p", new Atom(255, 0, 255));
        atomTable.put("s", new Atom(255, 255, 0));
        atomTable.put("hn", new Atom(150, 255, 150));
        defaultAtom = new Atom(255, 100, 200);
    }

    XYZChemModel() {
        this.mat.xrot(20.0);
        this.mat.yrot(30.0);
    }

    /*
     * Unable to fully structure code
     */
    XYZChemModel(InputStream var1_1) {
        this();
        try {
            var2_2 = new StreamTokenizer(new BufferedReader(new InputStreamReader(var1_1)));
            var2_2.eolIsSignificant(true);
            var2_2.commentChar(35);
            var3_4 = false;
            {
                switch (var2_2.nextToken()) lbl-1000:
                // 2 sources

                {
                    default: {
                        continue block6;
                    }
                    case -3: {
                        var4_5 = var2_2.sval;
                        var5_6 = 0.0;
                        var7_7 = 0.0;
                        var9_8 = 0.0;
                        if (var2_2.nextToken() == -2) {
                            var5_6 = var2_2.nval;
                            if (var2_2.nextToken() == -2) {
                                var7_7 = var2_2.nval;
                                if (var2_2.nextToken() == -2) {
                                    var9_8 = var2_2.nval;
                                }
                            }
                        }
                        this.addVert(var4_5, (float)var5_6, (float)var7_7, (float)var9_8);
                        while (true) {
                            if (var2_2.ttype == 10 || var2_2.ttype == -1) ** GOTO lbl-1000
                            var2_2.nextToken();
                        }
                    }
                    case -1: 
                }
            }
            var1_1.close();
            if (var2_2.ttype != -1) {
                throw new Error(var2_2.toString());
            }
        }
        catch (Exception var2_3) {
            throw new Error("Input error: " + var2_3);
        }
    }

    int addVert(String string, float f, float f2, float f3) {
        Object object;
        int n = this.nvert;
        if (n >= this.maxvert) {
            if (this.vert == null) {
                this.maxvert = 100;
                this.vert = new float[this.maxvert * 3];
                this.atoms = new Atom[this.maxvert];
            } else {
                this.maxvert *= 2;
                object = new float[this.maxvert * 3];
                System.arraycopy(this.vert, 0, object, 0, this.vert.length);
                this.vert = (float[])object;
                Atom[] atomArray = new Atom[this.maxvert];
                System.arraycopy(this.atoms, 0, atomArray, 0, this.atoms.length);
                this.atoms = atomArray;
            }
        }
        if ((object = (Atom)atomTable.get(string.toLowerCase())) == null) {
            object = defaultAtom;
        }
        this.atoms[n] = object;
        this.vert[n *= 3] = f;
        this.vert[n + 1] = f2;
        this.vert[n + 2] = f3;
        return this.nvert++;
    }

    void findBB() {
        float f;
        float f2;
        float f3;
        if (this.nvert <= 0) {
            return;
        }
        float[] fArray = this.vert;
        float f4 = f3 = fArray[0];
        float f5 = f2 = fArray[1];
        float f6 = f = fArray[2];
        int n = this.nvert * 3;
        while ((n -= 3) > 0) {
            float f7;
            float f8;
            float f9 = fArray[n];
            if (f9 < f3) {
                f3 = f9;
            }
            if (f9 > f4) {
                f4 = f9;
            }
            if ((f8 = fArray[n + 1]) < f2) {
                f2 = f8;
            }
            if (f8 > f5) {
                f5 = f8;
            }
            if ((f7 = fArray[n + 2]) < f) {
                f = f7;
            }
            if (!(f7 > f6)) continue;
            f6 = f7;
        }
        this.xmax = f4;
        this.xmin = f3;
        this.ymax = f5;
        this.ymin = f2;
        this.zmax = f6;
        this.zmin = f;
    }

    synchronized void paint(Graphics graphics) {
        int n;
        int n2;
        boolean bl;
        int n3;
        if (this.vert == null || this.nvert <= 0) {
            return;
        }
        this.transform();
        int[] nArray = this.tvert;
        int[] nArray2 = this.ZsortMap;
        if (nArray2 == null) {
            this.ZsortMap = nArray2 = new int[this.nvert];
            n3 = this.nvert;
            while (--n3 >= 0) {
                nArray2[n3] = n3 * 3;
            }
        }
        n3 = this.nvert - 1;
        while (--n3 >= 0) {
            bl = false;
            n2 = 0;
            while (n2 <= n3) {
                int n4 = nArray2[n2];
                n = nArray2[n2 + 1];
                if (nArray[n4 + 2] > nArray[n + 2]) {
                    nArray2[n2 + 1] = n4;
                    nArray2[n2] = n;
                    bl = true;
                }
                ++n2;
            }
            if (!bl) break;
        }
        bl = false;
        n2 = this.nvert;
        Atom[] atomArray = this.atoms;
        if (n2 <= 0 || this.nvert <= 0) {
            return;
        }
        n = 0;
        while (n < n2) {
            int n5 = nArray2[n];
            int n6 = nArray[n5 + 2];
            if (n6 < 0) {
                n6 = 0;
            } else if (n6 > 15) {
                n6 = 15;
            }
            this.atoms[n5 / 3].paint(graphics, nArray[n5], nArray[n5 + 1], n6);
            ++n;
        }
    }

    void transform() {
        if (this.transformed || this.nvert <= 0) {
            return;
        }
        if (this.tvert == null || this.tvert.length < this.nvert * 3) {
            this.tvert = new int[this.nvert * 3];
        }
        this.mat.transform(this.vert, this.tvert, this.nvert);
        this.transformed = true;
    }
}

