/*
 * Decompiled with CFR 0.152.
 */
package sunw.demo.classfile;

import java.io.DataOutputStream;
import java.io.IOException;
import sunw.demo.classfile.ClassFile;
import sunw.demo.classfile.ConstantPoolEntry;
import sunw.demo.classfile.UTF8Constant;

final class StringConstant
extends ConstantPoolEntry {
    private UTF8Constant string;

    StringConstant(String string, ClassFile classFile) {
        super((byte)8, classFile);
        this.string = classFile.addUTF8Constant(string);
        this.addToConstantPool();
    }

    StringConstant(UTF8Constant uTF8Constant, ClassFile classFile) {
        super((byte)8, classFile);
        this.string = uTF8Constant;
        this.addToConstantPool();
    }

    public boolean equals(Object object) {
        if (object instanceof StringConstant) {
            return this.string.equals(((StringConstant)object).string);
        }
        return false;
    }

    String getString() {
        return this.string.getString();
    }

    public int hashCode() {
        return this.string.hashCode();
    }

    void write(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeByte(this.getTag());
        dataOutputStream.writeShort(this.string.getConstantPoolIndex());
    }
}

