/*
 * Decompiled with CFR 0.152.
 */
package sunw.demo.classfile;

import java.io.DataOutputStream;
import java.io.IOException;
import sunw.demo.classfile.ClassFile;
import sunw.demo.classfile.ConstantPoolEntry;

class FloatConstant
extends ConstantPoolEntry {
    private float floating;

    FloatConstant(float f, ClassFile classFile) {
        super((byte)4, classFile);
        this.floating = f;
        this.addToConstantPool();
    }

    public boolean equals(Object object) {
        if (object instanceof Float) {
            return this.floating == ((Float)object).floatValue();
        }
        if (object instanceof FloatConstant) {
            FloatConstant floatConstant = (FloatConstant)object;
            return this.floating == floatConstant.getValue();
        }
        return false;
    }

    float getValue() {
        return this.floating;
    }

    public int hashCode() {
        return (int)this.floating;
    }

    void write(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeByte(this.getTag());
        dataOutputStream.writeFloat(this.floating);
    }
}

