/*
 * Decompiled with CFR 0.152.
 */
package peterson;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.Vector;
import peterson.TRMEvent;
import peterson.TRMListener;
import peterson.TRMStateMachine;
import peterson.TWEvent;
import peterson.TWListener;
import pwbuilder.core.StateMachine;
import pwbuilder.core.StateMachineAvailable;
import pwbuilder.core.SystemDescr;

public class TextResourceManager
implements Serializable,
TWListener,
StateMachineAvailable,
ActionListener,
Runnable {
    private transient Vector listns = new Vector();
    private transient boolean[][] requests;
    private transient boolean[] N;
    private transient boolean[] T;
    private transient boolean[] C;
    private transient TRMListener[] listeners;
    private transient int lsize;
    private transient Thread t = null;

    public TextResourceManager() {
        this.doInit();
    }

    private void doInit() {
        this.lsize = this.listns.size();
        this.requests = new boolean[this.lsize][this.lsize];
        this.N = new boolean[this.lsize];
        this.T = new boolean[this.lsize];
        this.C = new boolean[this.lsize];
        int n = 0;
        while (n < this.lsize) {
            int n2 = 0;
            while (n2 < this.lsize) {
                this.requests[n][n2] = true;
                ++n2;
            }
            this.N[n] = true;
            this.C[n] = false;
            this.T[n] = false;
            ++n;
        }
        this.listeners = this.listns.toArray(new TRMListener[0]);
    }

    private int getInternalPos(Object object) {
        int n = 0;
        while (n < this.lsize) {
            Object object2 = this.listeners[n];
            try {
                object2 = object2.getClass().getMethod("getTarget", null).invoke(object2, new Object[0]);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            if (object == object2) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    private boolean isLocked() {
        int n = 0;
        while (n < this.lsize) {
            if (this.C[n]) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public StateMachine getStateMachine(SystemDescr systemDescr) {
        return new TRMStateMachine(systemDescr, this);
    }

    public void run() {
        System.out.println(this + ":listeners=" + this.lsize);
        while (true) {
            TextResourceManager textResourceManager = this;
            synchronized (textResourceManager) {
                try {
                    this.wait(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (!this.isLocked()) {
                    int n = 0;
                    while (n < this.lsize) {
                        if (this.canEnterCS(n)) {
                            this.grantAccess(n);
                            break;
                        }
                        ++n;
                    }
                }
            }
        }
    }

    private boolean canEnterCS(int n) {
        if (!this.T[n]) {
            return false;
        }
        int n2 = 0;
        while (n2 < this.lsize) {
            if (!this.N[n2] && !this.requests[n][n2]) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private void grantAccess(int n) {
        this.T[n] = false;
        this.C[n] = true;
        int n2 = 0;
        while (n2 < this.lsize) {
            this.requests[n2][n] = true;
            ++n2;
        }
        this.listeners[n].receiveTRMEvent(new TRMEvent(this));
    }

    public void receiveTWEvent(TWEvent tWEvent) {
        int n = this.getInternalPos(tWEvent.getSource());
        if (n == -1) {
            return;
        }
        if (tWEvent.isRequest()) {
            System.out.println("TRM: request event from " + tWEvent.getSource());
        } else {
            System.out.println("TRM: release event from " + tWEvent.getSource());
        }
        if (tWEvent.isRequest()) {
            TextResourceManager textResourceManager = this;
            synchronized (textResourceManager) {
                this.N[n] = false;
                this.T[n] = true;
                int n2 = 0;
                while (n2 < this.lsize) {
                    if (n2 != n && this.T[n2]) {
                        this.requests[n][n2] = false;
                    }
                    ++n2;
                }
            }
        }
        TextResourceManager textResourceManager = this;
        synchronized (textResourceManager) {
            this.C[n] = false;
            this.N[n] = true;
        }
    }

    public synchronized void actionPerformed(ActionEvent actionEvent) {
        if (this.t == null || !this.t.isAlive()) {
            try {
                this.t = new Thread(this);
                this.t.start();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public synchronized void addTRMListener(TRMListener tRMListener) {
        this.listns.addElement(tRMListener);
        this.doInit();
    }

    public synchronized void removeTRMListener(TRMListener tRMListener) {
        this.listns.removeElement(tRMListener);
        this.doInit();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        Vector vector;
        TextResourceManager textResourceManager = this;
        synchronized (textResourceManager) {
            objectOutputStream.defaultWriteObject();
            vector = (Vector)this.listns.clone();
        }
        Iterator iterator = ((AbstractList)vector).iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof Serializable)) continue;
            objectOutputStream.writeObject(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        TextResourceManager textResourceManager = this;
        synchronized (textResourceManager) {
            objectInputStream.defaultReadObject();
            if (this.listns == null) {
                this.listns = new Vector();
            }
        }
        while (objectInputStream.available() > 0) {
            Object object = objectInputStream.readObject();
            if (!(object instanceof TRMListener)) continue;
            this.addTRMListener((TRMListener)object);
        }
    }
}

