/*
 * Decompiled with CFR 0.152.
 */
package sunw.demo.juggler;

import java.applet.Applet;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.image.ImageProducer;
import java.beans.DesignMode;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.beancontext.BeanContextChild;
import java.beans.beancontext.BeanContextChildSupport;
import java.beans.beancontext.BeanContextProxy;
import java.beans.beancontext.BeanContextServiceAvailableEvent;
import java.beans.beancontext.BeanContextServiceRevokedEvent;
import java.beans.beancontext.BeanContextServices;
import java.beans.beancontext.BeanContextServicesListener;
import java.net.URL;
import sunw.demo.methodtracer.MethodTracer;

public class Juggler
extends Applet
implements Runnable,
BeanContextProxy,
BeanContextServicesListener,
PropertyChangeListener,
DesignMode {
    private transient Image[] images;
    private transient Thread animationThread;
    private int rate = 125;
    private transient int loop;
    private boolean stopped = true;
    private boolean debug = false;
    private boolean dmode = false;
    private transient MethodTracer mtService;
    private transient MethodTracer mt;
    private BeanContextChildSupport bccs = new BeanContextChildSupport(){

        protected void initializeBeanContextResources() {
            try {
                BeanContextServices beanContextServices = (BeanContextServices)Juggler.this.bccs.getBeanContext();
                if (beanContextServices.hasService(class$sunw$demo$methodtracer$MethodTracer != null ? class$sunw$demo$methodtracer$MethodTracer : (class$sunw$demo$methodtracer$MethodTracer = Juggler.class$("sunw.demo.methodtracer.MethodTracer")))) {
                    Juggler.this.mtService = (MethodTracer)beanContextServices.getService(Juggler.this.getBeanContextProxy(), Juggler.this, class$sunw$demo$methodtracer$MethodTracer != null ? class$sunw$demo$methodtracer$MethodTracer : (class$sunw$demo$methodtracer$MethodTracer = Juggler.class$("sunw.demo.methodtracer.MethodTracer")), null, Juggler.this);
                } else {
                    beanContextServices.addBeanContextServicesListener(Juggler.this);
                }
                beanContextServices.addPropertyChangeListener("designMode", Juggler.this);
            }
            catch (ClassCastException classCastException) {
            }
            catch (Exception exception) {
                System.err.println("Error initializing BeanContext resources.");
                System.err.println(exception);
            }
        }

        protected void releaseBeanContextResources() {
            if (Juggler.this.mtService != null) {
                Juggler.this.mt = null;
                Juggler.this.mtService = null;
            }
            try {
                BeanContextServices beanContextServices = (BeanContextServices)this.getBeanContext();
                Juggler.this.bccs.removePropertyChangeListener("designMode", Juggler.this);
                beanContextServices.removeBeanContextServicesListener(Juggler.this);
            }
            catch (Exception exception) {}
        }
    };
    static /* synthetic */ Class class$sunw$demo$methodtracer$MethodTracer;

    static /* synthetic */ MethodTracer access$3(Juggler juggler) {
        return juggler.mt;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public int getAnimationRate() {
        return this.rate;
    }

    public BeanContextChild getBeanContextProxy() {
        return this.bccs;
    }

    public Dimension getMinimumSize() {
        return new Dimension(144, 125);
    }

    public Dimension getPreferredSize() {
        return this.minimumSize();
    }

    private void initialize() {
        this.images = new Image[5];
        int n = 0;
        while (n < 5) {
            String string = "Juggler" + n + ".gif";
            this.images[n] = this.loadImage(string);
            if (this.images[n] == null) {
                System.err.println("Couldn't load image " + string);
                return;
            }
            ++n;
        }
    }

    public boolean isDebug() {
        return this.debug;
    }

    public boolean isDesignTime() {
        return this.dmode;
    }

    public boolean isJuggling() {
        return this.stopped;
    }

    private Image loadImage(String string) {
        if (this.mt != null) {
            this.mt.traceMethod();
        }
        try {
            URL uRL = this.getClass().getResource(string);
            return this.createImage((ImageProducer)uRL.getContent());
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Dimension minimumSize() {
        return this.getMinimumSize();
    }

    public void paint(Graphics graphics) {
        if (this.mt != null) {
            this.mt.traceMethod();
        }
        int n = this.loop % 4 + 1;
        if (this.stopped) {
            n = 0;
        }
        if (this.images == null || n >= this.images.length) {
            return;
        }
        Image image = this.images[n];
        if (image != null) {
            graphics.drawImage(image, 0, 0, this);
        }
    }

    public Dimension preferredSize() {
        return this.getPreferredSize();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("designMode")) {
            boolean bl = (Boolean)propertyChangeEvent.getNewValue();
            this.setDesignTime(bl);
        }
    }

    public void run() {
        if (this.mt != null) {
            this.mt.traceMethod();
        }
        try {
            while (true) {
                Object object = this;
                synchronized (object) {
                    while (this.stopped || !this.isEnabled()) {
                        this.wait();
                    }
                }
                ++this.loop;
                object = this.getGraphics();
                Image image = this.images[this.loop % 4 + 1];
                if (object != null && image != null) {
                    ((Graphics)object).drawImage(image, 0, 0, this);
                }
                Thread.sleep(this.rate);
            }
        }
        catch (InterruptedException interruptedException) {
            return;
        }
    }

    public void serviceAvailable(BeanContextServiceAvailableEvent beanContextServiceAvailableEvent) {
        block2: {
            if (beanContextServiceAvailableEvent.getServiceClass() != (class$sunw$demo$methodtracer$MethodTracer != null ? class$sunw$demo$methodtracer$MethodTracer : (class$sunw$demo$methodtracer$MethodTracer = Juggler.class$("sunw.demo.methodtracer.MethodTracer")))) break block2;
            try {
                this.mtService = (MethodTracer)beanContextServiceAvailableEvent.getSourceAsBeanContextServices().getService(this.getBeanContextProxy(), this, class$sunw$demo$methodtracer$MethodTracer != null ? class$sunw$demo$methodtracer$MethodTracer : (class$sunw$demo$methodtracer$MethodTracer = Juggler.class$("sunw.demo.methodtracer.MethodTracer")), null, this);
            }
            catch (Exception exception) {
                System.err.println(exception);
            }
        }
    }

    public void serviceRevoked(BeanContextServiceRevokedEvent beanContextServiceRevokedEvent) {
        System.err.println("Method Tracing service revoked.");
        this.setDebug(false);
        this.mtService = null;
    }

    public void setAnimationRate(int n) {
        this.rate = n;
    }

    public void setDebug(boolean bl) {
        if (bl) {
            if (this.isDesignTime() && this.mtService != null) {
                this.mt = this.mtService;
                this.debug = true;
            } else if (this.mtService == null) {
                System.err.println("MethodTracer service not available.");
                this.debug = false;
            } else if (!this.isDesignTime()) {
                System.err.println("Debugging not available during runtime.");
                this.debug = false;
            }
        } else {
            this.mt = null;
            this.debug = false;
        }
    }

    public void setDesignTime(boolean bl) {
        this.dmode = bl;
        if (bl) {
            if (this.isDebug() && this.mtService != null) {
                this.mt = this.mtService;
            }
        } else if (!bl && this.mt != null) {
            this.mt = null;
        }
    }

    public synchronized void setEnabled(boolean bl) {
        if (this.mt != null) {
            this.mt.traceMethod();
        }
        super.setEnabled(bl);
        this.notify();
    }

    public synchronized void start() {
        this.startJuggling();
    }

    public synchronized void startJuggling() {
        if (this.mt != null) {
            this.mt.traceMethod();
        }
        if (this.images == null) {
            this.initialize();
        }
        if (this.animationThread == null) {
            this.animationThread = new Thread(this);
            this.animationThread.start();
        }
        this.stopped = false;
        this.notify();
    }

    public void startJuggling(ActionEvent actionEvent) {
        this.startJuggling();
    }

    public synchronized void stop() {
        this.stopJuggling();
    }

    public synchronized void stopJuggling() {
        if (this.mt != null) {
            this.mt.traceMethod();
        }
        this.stopped = true;
        this.loop = 0;
        Graphics graphics = this.getGraphics();
        if (graphics == null || this.images == null) {
            return;
        }
        Image image = this.images[0];
        if (image != null) {
            graphics.drawImage(image, 0, 0, this);
        }
    }

    public void stopJuggling(ActionEvent actionEvent) {
        this.stopJuggling();
    }
}

