/*
 * Decompiled with CFR 0.152.
 */
package sunw.beanbox;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.Vector;
import sunw.beanbox.PropertyHookupTarget;

public class PropertyHookup
implements PropertyChangeListener,
Serializable {
    static final long serialVersionUID = 4502052857914084293L;
    Object source;
    Hashtable targetsByPropertyName;

    public PropertyHookup(Object object) {
        this.source = object;
        this.targetsByPropertyName = new Hashtable();
    }

    public void attach(Object object, String string, Method method, Object object2, Method method2) {
        Vector<PropertyHookupTarget> vector = (Vector<PropertyHookupTarget>)this.targetsByPropertyName.get(string);
        if (vector == null) {
            vector = new Vector<PropertyHookupTarget>();
            this.targetsByPropertyName.put(string, vector);
        }
        int n = 0;
        while (n < vector.size()) {
            PropertyHookupTarget propertyHookupTarget = (PropertyHookupTarget)vector.elementAt(n);
            if (propertyHookupTarget.setter == method2 && propertyHookupTarget.object == object2) {
                return;
            }
            ++n;
        }
        vector.addElement(new PropertyHookupTarget(object2, method2));
        try {
            Object[] objectArray = new Object[]{};
            Object object3 = method.invoke(object, objectArray);
            Object[] objectArray2 = new Object[]{object3};
            method2.invoke(object2, objectArray2);
        }
        catch (InvocationTargetException invocationTargetException) {
            System.err.println("Property propagation failed");
            invocationTargetException.getTargetException().printStackTrace();
        }
        catch (Exception exception) {
            System.err.println("Property propagation failed");
            exception.printStackTrace();
        }
    }

    public void attach(String string, Object object, Method method) {
        Vector<PropertyHookupTarget> vector = (Vector<PropertyHookupTarget>)this.targetsByPropertyName.get(string);
        if (vector == null) {
            vector = new Vector<PropertyHookupTarget>();
            this.targetsByPropertyName.put(string, vector);
        }
        int n = 0;
        while (n < vector.size()) {
            PropertyHookupTarget propertyHookupTarget = (PropertyHookupTarget)vector.elementAt(n);
            if (propertyHookupTarget.setter == method && propertyHookupTarget.object == object) {
                return;
            }
            ++n;
        }
        vector.addElement(new PropertyHookupTarget(object, method));
    }

    public Method getSetterMethod(Object object) {
        PropertyHookupTarget propertyHookupTarget = (PropertyHookupTarget)object;
        return propertyHookupTarget.setter;
    }

    public Object getTargetObject(Object object) {
        PropertyHookupTarget propertyHookupTarget = (PropertyHookupTarget)object;
        return propertyHookupTarget.object;
    }

    public Hashtable getTargetsByProperty() {
        return this.targetsByPropertyName;
    }

    public synchronized void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        Vector vector = (Vector)this.targetsByPropertyName.get(string);
        if (vector == null) {
            return;
        }
        Object[] objectArray = new Object[]{propertyChangeEvent.getNewValue()};
        int n = 0;
        while (n < vector.size()) {
            PropertyHookupTarget propertyHookupTarget = (PropertyHookupTarget)vector.elementAt(n);
            try {
                propertyHookupTarget.setter.invoke(propertyHookupTarget.object, objectArray);
            }
            catch (InvocationTargetException invocationTargetException) {
                System.err.println("Property set failed");
                invocationTargetException.getTargetException().printStackTrace();
            }
            catch (Exception exception) {
                System.err.println("Unexpected Property set exception");
                exception.printStackTrace();
            }
            ++n;
        }
    }

    public void vetoablePropertyChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
        this.propertyChange(propertyChangeEvent);
    }
}

