/*
 * Decompiled with CFR 0.152.
 */
package sunw.demo.quote;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.Naming;
import java.rmi.RemoteException;
import sunw.demo.quote.PropertyPanel;
import sunw.demo.quote.QuoteEvent;
import sunw.demo.quote.QuoteListener;
import sunw.demo.quote.QuoteListenerImpl;
import sunw.demo.quote.QuoteServer;

public class QuoteMonitor
extends Panel {
    private transient QuoteListener quoteListener = null;
    private transient QuoteServer quoteServer = null;
    private PropertyChangeSupport changes = new PropertyChangeSupport(this);
    private QuoteEvent currentQuote = null;
    private PropertyPanel quotePanel = new PropertyPanel();
    private static final String sSymbol = "Stock";
    private static final String sPrice = "Price";
    private static final String sServer = "Server";
    private static final String sStatus = "Status";
    Frame dialog = null;

    public QuoteMonitor() {
        String string;
        Object object;
        try {
            object = InetAddress.getLocalHost();
            string = ((InetAddress)object).getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            string = "mushmouth";
        }
        this.quotePanel.appendProperty(sSymbol, "sunw");
        this.quotePanel.appendProperty(sPrice);
        this.quotePanel.appendProperty(sServer, string);
        this.quotePanel.appendProperty(sStatus, "Initializing ...");
        this.add(this.quotePanel);
        object = new InitQuoteMonitorThread();
        ((Thread)object).start();
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changes.addPropertyChangeListener(propertyChangeListener);
    }

    void closeBadServerDialog() {
        this.dialog.dispose();
        this.dialog = null;
    }

    synchronized void connectToServer() {
        String string = this.quotePanel.getPropertyValue(sServer);
        this.quotePanel.setPropertyValue(sStatus, "Not Connected");
        String string2 = "rmi://" + string + ":2330/QuoteServer";
        try {
            if (this.quoteListener != null && this.quoteServer != null) {
                try {
                    this.quoteServer.removeQuoteListener(this.quoteListener);
                }
                catch (RemoteException remoteException) {}
            }
            this.quoteServer = (QuoteServer)Naming.lookup(string2);
            this.quoteListener = new QuoteListenerImpl(this);
            this.quoteServer.addQuoteListener(this.quoteListener);
            this.quotePanel.setPropertyValue(sStatus, "Connected to " + string);
        }
        catch (Exception exception) {
            this.quotePanel.setPropertyValue(sStatus, "Bad server host");
            this.quoteServer = null;
            this.quoteListener = null;
            this.showBadServerDialog(string);
        }
    }

    public String getQuoteServerHost() {
        return this.quotePanel.getPropertyValue(sServer);
    }

    public String getStockSymbol() {
        return this.quotePanel.getPropertyValue(sSymbol);
    }

    private void maybeFirePropertyChange(String string, double d, double d2) {
        this.changes.firePropertyChange(string, new Double(d), new Double(d2));
    }

    private void maybeFirePropertyChange(String string, long l, long l2) {
        this.changes.firePropertyChange(string, new Long(l), new Long(l2));
    }

    private void maybeFirePropertyChange(String string, Object object, Object object2) {
        this.changes.firePropertyChange(string, object, object2);
    }

    public void quoteChanged(QuoteEvent quoteEvent) {
        this.quotePanel.setPropertyValue(sSymbol, quoteEvent.getSymbol());
        this.quotePanel.setPropertyValue(sStatus, "Quote " + quoteEvent.getDate().toString());
        this.quotePanel.setPropertyValue(sPrice, String.valueOf(quoteEvent.getPrice()));
        QuoteEvent quoteEvent2 = this.currentQuote;
        this.currentQuote = quoteEvent;
        if (quoteEvent2 != null) {
            this.maybeFirePropertyChange("symbol", quoteEvent2.getSymbol(), quoteEvent.getSymbol());
            this.maybeFirePropertyChange("date", quoteEvent2.getDate(), quoteEvent.getDate());
            this.maybeFirePropertyChange("price", quoteEvent2.getPrice(), quoteEvent.getPrice());
            this.maybeFirePropertyChange("bid", quoteEvent2.getBid(), quoteEvent.getBid());
            this.maybeFirePropertyChange("ask", quoteEvent2.getAsk(), quoteEvent.getAsk());
            this.maybeFirePropertyChange("open", quoteEvent2.getOpen(), quoteEvent.getOpen());
            this.maybeFirePropertyChange("volume", quoteEvent2.getVolume(), quoteEvent.getVolume());
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        InitQuoteMonitorThread initQuoteMonitorThread = new InitQuoteMonitorThread();
        initQuoteMonitorThread.start();
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changes.removePropertyChangeListener(propertyChangeListener);
    }

    public void setQuoteServerHost(String string) {
        this.quotePanel.setPropertyValue(sServer, string);
        InitQuoteMonitorThread initQuoteMonitorThread = new InitQuoteMonitorThread();
        initQuoteMonitorThread.start();
    }

    public void setStockSymbol(String string) {
        this.quotePanel.setPropertyValue(sSymbol, string);
    }

    public void showBadServerDialog(String string) {
        String[] stringArray = new String[]{"The QuoteMonitor Bean couldn't connect to the QuoteServer", "on host machine \"" + string + "\".  Either specify a hostname", "where the QuoteServer is already running or start/restart", "one on \"" + string + "\".", "  ", "You can start the QuoteServer from the demo directory with:", "   start nmake -f quote.mk run (Windows)", "   gnumake -f quote.gmk run & (Solaris)"};
        String string2 = "QuoteMonitor Warning: \"" + string + "\" Couldn't Connect to Quote Server";
        if (this.dialog != null) {
            this.dialog.setTitle(string2);
            return;
        }
        this.dialog = new Frame(string2);
        this.dialog.setLayout(new BorderLayout(3, 3));
        this.dialog.addWindowListener(new DialogCloseHandler());
        Panel panel = new Panel();
        panel.setLayout(new GridLayout(stringArray.length, 1));
        int n = 0;
        while (n < stringArray.length) {
            panel.add(new Label("  " + stringArray[n]));
            ++n;
        }
        Button button = new Button(" OK ");
        button.addActionListener(new DialogOKHandler());
        Panel panel2 = new Panel();
        panel2.add(button);
        this.dialog.add("Center", panel);
        this.dialog.add("South", panel2);
        this.dialog.pack();
        this.dialog.show();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
    }

    class InitQuoteMonitorThread
    extends Thread {
        InitQuoteMonitorThread() {
        }

        public void run() {
            QuoteMonitor.this.connectToServer();
        }
    }

    class DialogOKHandler
    implements ActionListener {
        DialogOKHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            QuoteMonitor.this.closeBadServerDialog();
        }
    }

    class DialogCloseHandler
    extends WindowAdapter {
        DialogCloseHandler() {
        }

        public void windowClosing(WindowEvent windowEvent) {
            QuoteMonitor.this.closeBadServerDialog();
        }
    }
}

