/*
 * Decompiled with CFR 0.152.
 */
package sunw.demo.misc;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Date;

public class TickTock
implements Runnable,
Serializable {
    private PropertyChangeSupport changes = new PropertyChangeSupport(this);
    private int interval = 5;
    transient Thread runner;

    public TickTock() {
        this.reset();
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changes.addPropertyChangeListener(propertyChangeListener);
    }

    public int getInterval() {
        return this.interval;
    }

    public int getSeconds() {
        return (int)(new Date().getTime() / 1000L);
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        this.reset();
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changes.removePropertyChangeListener(propertyChangeListener);
    }

    private void reset() {
        this.runner = new Thread(this);
        this.runner.start();
    }

    public void run() {
        int n = this.getSeconds();
        while (true) {
            try {
                Thread.sleep(this.interval * 1000);
            }
            catch (InterruptedException interruptedException) {}
            int n2 = this.getSeconds();
            this.changes.firePropertyChange("seconds", new Integer(n), new Integer(n2));
            n = n2;
        }
    }

    public void setInterval(int n) {
        this.interval = n;
        if (this.runner != null) {
            this.runner.interrupt();
        }
    }
}

