;; x-filter: (X X -> Boolean) X (listof X) -> (listof X)
;; find those in lox for which f is true compared to x
(define (x-filter f x lox)
    (filter (lambda (n) (f n x)) lox))

(define (above n lon) (x-filter > n lon))
(define (string-above s los) (x-filter string>? s los))

;; Examples
(equal? (above 3 empty) empty)
(equal? (above 3 (list 1 2 3 4 5)) (list 4 5))

;; Examples
(equal? (string-above "c" empty) empty)
(equal? (string-above "c" (list "a" "b" "c" "d" "e")) (list "d" "e"))