;; num-filter: (Number Number -> Boolean) N LoN -> LoN
;; find those in lon for which f is true compared to N
(define (num-filter f n lon)
  (cond
    [(empty? lon) empty]
    [else (cond [(f (first lon) n)
                 (cons (first lon) (num-filter f n (rest lon)))]
                [else
                 (num-filter f n (rest lon))])]))

(define (below n lon) (num-filter < n lon))
(define (above n lon) (num-filter > n lon))

;; Examples
(equal? (above 3 empty) empty)
(equal? (above 3 (list 1 2 3 4 5)) (list 4 5))

;; Examples
(equal? (below 3 empty) empty)
(equal? (below 3 (list 1 2 3 4 5)) (list 1 2))