;; mul-all: (listof Number) -> (listof Number)
;; triples all in lond
(define (mul-all n l)
  (cond
    [(empty? l) empty]
    [else (cons (* n (first l)) (mul-all n (rest l)))]))

(define (double-all l) (mul-all 2 l))
(define (triple-all l) (mul-all 3 l))


;; Examples
(equal? (double-all empty) empty)
(equal? (double-all (list 1 2 5)) (list 2 4 10))
  
;; Examples
(equal? (triple-all empty) empty)
(equal? (triple-all (list 1 2 5)) (list 3 6 15))
