;; TEMPLATE for posn
#|
(define (f p)
  ... (posn-x p) ...
  ... (posn-y p) ... ))
|#

#|
(define (f lop)
  (cond
    [(empty? lop) ... ]
    [else .. (first lop) ... (f (rest lop)) ...]))
|#

;; similar?: Posn Posn -> Boolean
;; whether p1 and p2 are 'similar'
(define (similar? p1 p2)
  (local ((define px1 (posn-x p1))
          (define py1 (posn-y p1))
          (define px2 (posn-x p2))
          (define py2 (posn-y p2))
  (or (= px1 px2) (= px1 py2) (= py1 px2)(= py1 py2);5
))

;; Examples/Tests
(not (similar? (make-posn 1 2) (make-posn 3 4))) ; 1
(similar? (make-posn 1 2) (make-posn 1 3))       ; 2
(similar? (make-posn 1 2) (make-posn 3 1))       ; 3
(similar? (make-posn 1 2) (make-posn 2 3))       ; 4
(similar? (make-posn 1 3) (make-posn 2 3))       ; 5

;; find-similar: Posn listof[Posn] -> listof[Posn]
;; finds the posns in lop similar to p
(define (find-similar p lop)
  (cond
    [(empty? lop) empty ]
    [else (cond
            [(similar? p (first lop)) (cons (first lop) 
                                            (find-similar p (rest lop)))]
            [else (find-similar p (rest lop))])]))




;; Examples/Tests
(define P (make-posn 3 4))
(equal? (find-similar P empty) empty)
(equal? (find-similar P (list P)) (list P))
