% test code: how features were evaluated and how to evaluate the same
% features from a new data window
% 
% [Andrea Mannini: a.mannini@sssup.it; Created: 2012. Last changes: Sept 2013]

clear all

load StanfordDataset2010_corrected_Ankle_MSSE.mat  % this file already have features in it, here
                                                   %   we just test they are consistent with the 
                                                   %   saved version by re-evaluating them 


for p = 1:length(Data)
    
    fs = Info(p).fs;
    windowL = Info(p).window;
    data_win = Data(p).raw_m;
    time = Data(p).time;
    
    [feats{p}, name] = evaluatefeatures_MSSE(data_win, fs, windowL, time);  
    
    test(p) = sum(sum(Data(p).Pm == feats{p})) == (size(feats{p},1)*size(feats{p},2)); 
    disp(['Test, participant ' num2str(p) ': ' num2str(test(p))]); 
end
