function  [CM_aggr, CM, Acc_aggr, Acc, predict, model, prob] = l1o_valid_svm2(inst, labels, subj_label, sc_low, sc_up, kernel, C, gamma, Pb, termination, maxlabelnum)
              
% inst = data
% labels = class label
% subj_label = subject ID
% sc_low, sc_up not required if scaling 2 is applied
% kernel, C, gamma, Pb, termination = SVM parameters
% maxlabelnum = number of labels, just for visualization purposes
% 
% [Andrea Mannini: a.mannini@sssup.it; c2012]          


%% Leave-one-subject out validation approach:
% scaling, training, classification,
% confusion matrix evaluation.
% Each fold result is saved and the algorithm continues until when all subjects are tested. 
[N,F] = size(inst);
ind = unique(subj_label);
Nsogg = length(ind);

% select scaling approach 
scaling1 = false; % scaling in the range sc_low:sc_high, for example -1:1
scaling2 = true;  % regularization (datum - mean)/ standarddev


h = waitbar(0,'SVM: leave-1-out validation');
if (Nsogg == 1)
    disp(' --- Leave-1-out validation error: Nsogg must be at least 2 --- ')
    CM_aggr = [];
    CM = [];
    Acc_aggr = [];
    Acc = [];
    predict = [];
else

    lab = unique(labels);
    CM = zeros(max(lab),max(lab),Nsogg);

    for n = 1:Nsogg   
        waitbar((n-1)/Nsogg,h)
        
        %% assign TS e VS
        TS_inst_sc = [];
        VS_inst_sc = [];

        ne = []; lablist = [];
        
        VS_ind = (subj_label == ind(n));
        TS_ind = (subj_label ~= ind(n));

        TS_label = labels(TS_ind);
        TS_inst = inst(TS_ind,:);
        VS_label = labels(VS_ind);
        VS_inst = inst(VS_ind,:);
        
        %%
        if scaling1
            % scaling
            M = max(TS_inst);  %max e min per ogni feature
            m = min(TS_inst);
            for f = 1:F
                TS_inst_sc(:,f) = ones(length(TS_inst(:,f)),1)*sc_low + (TS_inst(:,f)-ones(length(TS_inst(:,f)),1)*m(f)) .* (sc_up-sc_low)/(M(f)-m(f));
                VS_inst_sc(:,f) = ones(length(VS_inst(:,f)),1)*sc_low + (VS_inst(:,f)-ones(length(VS_inst(:,f)),1)*m(f)) .* (sc_up-sc_low)/(M(f)-m(f));
            end
        elseif scaling2
            % scaling
            me = mean(TS_inst); 
            st = std(TS_inst);
            for f = 1:F
                TS_inst_sc(:,f) = (TS_inst(:,f) - me(f)) ./ st(f);
                VS_inst_sc(:,f) = (VS_inst(:,f) - me(f)) ./ st(f);
            end
        end

        %% train and test      
        if(Pb)
            model{n} = svmtrain(TS_label, TS_inst_sc, [' -t ' num2str(kernel)  ' -c ' num2str(C, '%12.12f') ' -g ' num2str(gamma, '%12.12f') ' -b ' num2str(Pb) ' -e ' num2str(termination, '%12.12f') ]);
            [predict{n}, accuracy(:,n), prob_tmp{n}] = svmpredict(VS_label, VS_inst_sc, model{n}, [' -b ' num2str(Pb)] );
        else
            model{n} = svmtrain(TS_label, TS_inst_sc, [' -t ' num2str(kernel)  ' -c ' num2str(C, '%12.12f') ' -g ' num2str(gamma, '%12.12f') ' -e ' num2str(termination, '%12.12f') ]);
            [predict{n}, accuracy(:,n)] = svmpredict(VS_label, VS_inst_sc, model{n} );
        end

        lab1 = unique(VS_label);  
        lab3 = unique(TS_label);  %  stato aggiunto il 1ott2010
        lab2 = unique(predict{n});
        % confusion matrix
        [CM(lab1,lab2,n),ne,lablist] = confmat(VS_label, predict{n});
        
        if(Pb)
            % only in soft-assignment case
            [L U] = size(prob_tmp{n});
            prob{n}= zeros(L,maxlabelnum);
            prob{n}(:,lab3) = prob_tmp{n};
        else
            prob{n} = [];
        end

    end

    %% Results aggregation
    CM_aggr = sum(CM,3);
    Acc_aggr = sum(accuracy(1,:))/Nsogg;
    Acc = accuracy(1,:);
end
close (h)




%% SVM PARAMS (memo)
% options:
% -s svm_type : set type of SVM (default 0)
% 	0 -- C-SVC
% 	1 -- nu-SVC
% 	2 -- one-class SVM
% 	3 -- epsilon-SVR
% 	4 -- nu-SVR
% -t kernel_type : set type of kernel function (default 2)
% 	0 -- linear: u'*v
% 	1 -- polynomial: (gamma*u'*v + coef0)^degree
% 	2 -- radial basis function: exp(-gamma*|u-v|^2)
% 	3 -- sigmoid: tanh(gamma*u'*v + coef0)
% -d degree : set degree in kernel function (default 3)
% -g gamma : set gamma in kernel function (default 1/num_features)
% -r coef0 : set coef0 in kernel function (default 0)
% -c cost : set the parameter C of C-SVC, epsilon-SVR, and nu-SVR (default 1)
% -n nu : set the parameter nu of nu-SVC, one-class SVM, and nu-SVR (default 0.5)
% -p epsilon : set the epsilon in loss function of epsilon-SVR (default 0.1)
% -m cachesize : set cache memory size in MB (default 100)
% -e epsilon : set tolerance of termination criterion (default 0.001)
% -h shrinking: whether to use the shrinking heuristics, 0 or 1 (default 1)
% -b probability_estimates: whether to train a SVC or SVR model for probability estimates, 0 or 1 (default 0)
% -wi weight: set the parameter C of class i to weight*C, for C-SVC (default 1)
% 
% The k in the -g option means the number of attributes in the input data.
% To install this tool, please read the README file in the package. There are Windows, X, and Java versions in the package.

