% Calcola la sensibilit e la specificit di classificazione nelle C classi 
% dove C  la dimensione della matrice di confusione CM (CxC). Le righe si
% riferiscono all'uscita del classificatore, le colonne alla classe reale
% di appartenenza dei dati
% 
% Inputs:
% CM matrice di confusione
% verbose stampa output se diverso da zero (default = 0)
% 
% Outputs:
% SE sensibilit globale (aka Recall)
% SP specificit globale
% PR precision globale
% se sensibilit classificazione singola classe (aka recall)
% sp specificit classificazione singola classe
% pr precision classificazione singola classe
% tp,tn,fp,fn veri positivi, veri negativi, falsi positivi e falsi negativi
%               per la singola classe
% ------------------------------------------------------------------------
% 
%  [SE,SP,PR,se,sp,pr,tp,fp,tn,fn] = confmat2SeSpPr(CM,0)
% 
% Extract the sensitivity and specificity for classification into classes
% C where C is the size of the confusion matrix CM (CXC). The lines
% refers to the output of the classifier, the columns to the actual class
% membership
% 
% Upper case = global values;
% Lower case = class specific values.
% 
% Inputs:
% CM confusion matrix
% verbose if not null print the output (default = 0)
% 
% Outputs:
% SE global sensitivity (aka Recall)
% SP global specificity 
% PR global precision 
% se single class sensitivity (aka recall)
% sp single class specificity
% pr single class precision 
% tp,tn,fp,fn single class true positives, true negatives, false positives
% and false negatives
% 
% ------------------------------------------------------------------------
% 
% [Andrea Mannini: a.mannini@sssup.it; Last modified: Mar 10 2011]


