%PREX_DATASETS  PRTools example of the standard datasets
%
% Shows quickly the scatter-plots for each pair of the 
% consecutive features from the standard datasets.

%addph datasets
data = str2mat(...
'gauss', ...
'gendatb', ...
'gendatc', ...
'gendatd', ...
'gendath', ...
'gendatl', ...
'gendatm', ...
'gendats', ...
'gencirc', ...
'lines5d', ...
'x80', ...
'auto_mpg', ...
'malaysia', ...
'biomed', ...
'breast', ...
'cbands', ...
'chromo', ...
'circles3d', ...
'diabetes', ...
'ecoli', ...
'glass', ...
'heart', ...
'imox', ...
'glass', ...
'heart', ...
'imox', ...
'iris', ...
'ionosphere', ...
'liver', ...
'ringnorm', ...
'sonar', ...
'soybean1', ...
'soybean2', ...
'twonorm', ...
'wine');

delfigs
figure

disp(' ')
disp('   Consecutive feature pairs of the standard datasets are shown')
disp('   in a scatter-plot. This may take a few minutes.')
disp(' ')

for j=1:size(data,1);
  a = feval(deblank(data(j,:)));
	a
  if size(a,2) == 1
    scatterd(a,1);
    drawnow
    pause(0.2)
  else
    for i=2:size(a,2)
      scatterd(a(:,[i-1,i]));
      drawnow
      pause(0.1)
    end
  end
end
  
